#!/usr/bin/perl

use strict;

#-----------------------------------------------------------------------------
# Constants

#$::NULL    = pack("C", 0);

#-----------------------------------------------------------------------------
# Global Variables

my (@pairs, $rfile, $i,);

@pairs = &extract_pairs();

# check if "id" is present in the GET command
if ($pairs[0] eq "id") {
	$rfile = "./data/$pairs[1].dat";
	open (RFILE, ">>$rfile") || die "Cannot open file $rfile";
	for ($i=0; $i<6; $i++) { 
		print RFILE "$pairs[$i] ";
		}
	print RFILE "\n";
	close (RFILE);
	#blank line for header/body separation
	print "\r\n";
	#body text
	# 00 means OK 
	print "00 ";
	# calculate and send back the number to refill A,B
	printf "%02x", (16-hex($pairs[3]));
	print " ";
	printf "%02x", (16-hex($pairs[5])); 
	#end of body
	print "\r\n";
	}
else {
	print "\r\n";
	# 01 means error
	print "01";
	print "\r\n";
	}

exit(0);

#-----------------------------------------------------------------------------
# Read a HTTP request from the environment vars and STDIN
# return the result in an associative dictionary with one entry
# for each key/value pair sent from the client.
# Does not support more than one value per key.
# May err out if there is an error in the request.
# Supports GET, POST, and a testing mode where it reads
# the query string out of $ARGV[0].

sub extract_pairs() {
#	my ($pairs, %pairs);
	my ($pairs, @pairs);
	my ($request_method, $content_length);

	$request_method = $ENV{"REQUEST_METHOD"};  # These are global, but that
	$content_length = $ENV{"CONTENT_LENGTH"};  # might not be all bad.

	# If the method is the empty string, figure we're being invoked
	# from the shell for testing and so use the string from ARGV[0]
	if ($request_method eq "") {	
		$pairs = $ARGV[0];
	} elsif ($request_method eq "POST") {
		read(STDIN, $pairs, $content_length);  # POST => read from STDIN
	} elsif ($request_method eq "GET") {
		$pairs = $ENV{"QUERY_STRING"};         # GET = > read from ENV variable
	} else {
		die "Unrecognized CGI method \"$request_method\".";
	}

	# The following is the standard hack for decoding the pairs
	# 1) Change '&' and '=' to '\0'.
	$pairs =~ tr/&=/\0/;

	# 2) Change '+' to space
#	$pairs =~ tr/+/ /;

	# 3) Change the "%20" type encodings back to regular chars
	#    The [\da-fA-F] defines a single hex digit.
#	$pairs =~ s/%([\da-fA-F][\da-fA-F])/pack("c", hex($1))/ge;

	# 4) Slam the whole string into an associative key/value array
	#    which is returned. This only supports one value per key.
#	%pairs = split(/\0/, $pairs);
	@pairs = split(/\0/, $pairs);

#	return(%pairs);
	return(@pairs);
}

