//-----------------------------------------------------------------------------
// lpf.c - ment to filter raw ASCII files in the iReady Debug Sound Format.
//			Which is one ASCII hex sample per line.
//
// Mike Johnson	iReady	- stolen from mycal labs
//-----------------------------------------------------------------------------      
#include <stdio.h>
#include <string.h>

//
// readln_from_a_file
// 
int
readln_from_a_file(fp, line, size)
FILE    *fp;
char    *line;
int     size;
{
        char *p;
 
        do
                p = fgets( line, size, fp );
        while( ( p != NULL ) && ( *line == '#') );

        if( p == NULL )
                return( 0 );

        if (strchr(line, '\n'))
          *strchr(line, '\n') = '\0';
        if (strchr(line, '\r'))
          *strchr(line, '\r') = '\0';
        return( 1 );
}
 
 
main(argc,argv)
int 	argc;
char 	**argv;
{                    
char			line[25];
char			*filename;
int				ch;    
unsigned int	a,b,c;
unsigned char	data;
         
	if(argc==1)
	{
		;
	}         
	else if (argc==2)
	{   
		if (!freopen(filename = argv[1], "rb", stdin)) 
		{
 			printf("\nError opening file %s.\n",filename);
  			exit(1);
  		}
    }
	else
	{             							
		printf("\nCorrect usage is: lpf [file]\n");
		printf("	If file is not specified lpf will use stdin.");  
		exit(1);
	}										
	
	//
	// File is open or we are using stdin. Start filtering using a very
	// 	simple low pass filter.  First set a=b=c=0x80 to initialize
	// 	the filter.
	//	           
	a=b=c=0x80;
	
	//
	// Start readling lines, each line should contain one sample
	//											
	while(readln_from_a_file(stdin, &line, 20))
	{
        //
		// shift samples through filter
		//	
		a=b;
		b=c;                           
		//
		// Get sample from line
		//
		sscanf(line,"%x",&c);
		//
		// Do filter
		//          
		data=(a+(b<<1)+c)>>2;
		//
		// send to output
		//				
		printf("%.2x\n",data);	
    }
                              
}                              