//------------------------------------------------------------------------------
// downsamp.c	- Mike Johnson - iReady
//
//------------------------------------------------------------------------------          
#include <stdio.h>
#include "wave.h"

/*
//
//
int
sixteen_2_eight_bit(sound)
SOUND	*sound;					
{            
DWORD	i;
DWORD	temp;
HPSTR	data8;  
int _huge	*data16;

	if(sound->format.wBitsPerSample==16)
	{                
		data8=sound->data;
		data16=(int huge *)data8;
		//
		// Convert the 16 bit samples to 8 bit samples.  This is
		//	done by tossing away the 8 least significant bits, and
		//	adding in the MSB of the through away bits back into
		//	the 8 most significant bits.
		//
		for(i=0;i<(sound->data_size/2);i++)
		{
			temp=data16[i];
			//flip msb to convert to linear
			temp=(temp ^ 0x8000); // Convert to linear
			data8[i]=(BYTE)( ((temp>>8) + ((temp<<7)&0x1)) &0xff);
		}
        //
		// set the new format.
		//
		sound->format.wBitsPerSample=8;  
		sound->format.nBlockAlign/=2;
		sound->format.nAvgBytesPerSec/=2; 
		sound->data_size=sound->data_size/2;

		return 0;
    }
	else
		return-1;
} 
   
//
//
//
int   
stereo_2_mono(sound)
SOUND	*sound;
{     
DWORD	i,j;
WORD	temp;
BYTE _huge	*data8;

	if(sound->format.nChannels==2)
	{       
		data8=sound->data;
		//
		// Convert Stereo to Mono.  This is done by adding the two
		// channels togeather and dividing by 2.
		//
		for(i=0,j=0;i<sound->data_size-2;i+=2,j++)
		{
			temp=((WORD)data8[i]+(WORD)data8[i+1])/2;
			data8[j]=(BYTE)temp;       
		}																
		//
		// Set new Data size and number of channels
		//
		sound->format.nChannels=1;
		sound->format.nAvgBytesPerSec/=2; 
		sound->format.nBlockAlign/=2;
		sound->data_size/=2;
		return 0;				
	}
	else
		return -1;
} 
   
int   
eleven_2_eight(sound)
SOUND	*sound;
{  
unsigned long	i,j;
HPSTR	data8; 


	if((sound->format.nSamplesPerSec & 0xffffff00)==0x0002b00)
	{
		data8=sound->data;		
		//
		// Convert 11khz to 8khz
		//  	We do this by taking 3 bytes, then dropping one.
		//	
		for(i=0,j=0;j<sound->data_size-2;i+=3,j+=4)
		{
			data8[i]=data8[j];
			data8[i+1]=data8[j+1];
			data8[i+2]=data8[j+2];
		}		
        //
        // Set samples per second
        //
        sound->data_size=i;
        sound->format.nAvgBytesPerSec=													
		sound->format.nSamplesPerSec= (long)(sound->format.nSamplesPerSec * .75);	
	}
	else
		return 1;
}

int
twentytwo_2_eight(sound)
SOUND	*sound;
{             
unsigned long	i,j;
HPSTR	data8;

	if((sound->format.nSamplesPerSec & 0xffffff00)==0x0005600)
	{
		data8=sound->data;		
		//
		// Convert 11khz to 8khz
		//  	We do this by taking 1 byte, then dropping two.
		//	
		for(i=0,j=0;j<sound->data_size-8;i+=3,j+=8)
		{
			data8[i]=data8[j];    
			data8[i+1]=data8[j+3];
			data8[i+2]=data8[j+6];
		}	
		//
		// Set Samples Per Second
		//	
		sound->data_size=i;
		sound->format.nAvgBytesPerSec=
		sound->format.nSamplesPerSec=(long)(sound->format.nSamplesPerSec * (.375));														

	}
	else
		return 1;
	
	return -1;
}

int
fourtyfour_2_eight(sound)
SOUND	*sound;
{
unsigned long	i,j;
HPSTR	data8;

	if((sound->format.nSamplesPerSec & 0xffffff00)==0x000ac00)
	{
		data8=sound->data;		
		//
		// Convert 44khz to 8khz
		//  	We do this by taking 1 bytes, then dropping 4.
		//	
		for(i=0,j=0;j<sound->data_size-16;i+=3,j+=16)
		{
			data8[i]=data8[j];                
			data8[i+1]=data8[j+5];  
			data8[i+2]=data8[j+11];  						
		}		
		//
		// Set Samples Per Second
		//
		sound->format.nAvgBytesPerSec=
		sound->format.nSamplesPerSec=
			(long)(sound->format.nSamplesPerSec * .1875);		
		sound->data_size=i;												
	}
	else
		return 1;

	return -1;
}
*/  

BYTE
getbyte(file)
FILE	*file;
{

	if(feof(file)==0)
		return(fgetc(file));
	else
		return(0);	
}                 

WORD
getword(file)
FILE	*file;
{
	if(feof(file)==0)
		return(getw(file));
	else
		return(0);	
}



DWORD	count=0;    
    
const BYTE
get_sound_byte(infile,info)
FILE			*infile;          
WAVEFORMATEX	*info;
{
WORD		temp;
BYTE		byte,byte1,byte2;
    //
    // Check for stereo
    //
	if(info->nChannels==2)
	{                  
		//
		// we are stereo, now check for 16 or 8 bits per sample
		//
		if(info->wBitsPerSample==16)
		{       
			count=count+4;
			//
			// 16 bits per sample, grab samples and convert to 8 bit then
			//		mono.
			//
			temp=(getword(infile) ^ 0x8000) ; 	// convert to linear
			byte1=(BYTE)( ((temp>>8) + ((temp<<7)&0x1)) &0xff);
			// convert 2nd sample to 8 bit
			temp=(getword(infile) ^ 0x8000) ; 	// convert to linear
			byte2=(BYTE)( ((temp>>8) + ((temp<<7)&0x1)) &0xff);
			// convet to mono			             
			temp=((WORD)byte1+(WORD)byte2)/2;
            byte=(BYTE)temp;
		}
		else if(info->wBitsPerSample==8)
		{                 
			count=count+2;
			byte1=getbyte(infile);
			byte2=getbyte(infile);		
			// convet to mono			             
			temp=((WORD)byte1+(WORD)byte2)/2;
			byte=(BYTE)temp;
		}
	} 
	else 
	{	
		if(info->wBitsPerSample==16)
		{                 
			count=count+2;
			//
			// 16 bits per sample, grab sample and convert to 8 bit then
			//		mono.
			//
			temp=(getword(infile) ^ 0x8000) ; 	// convert to linear
			byte=(BYTE)( ((temp>>8) + ((temp<<7)&0x1)) &0xff);
		}
		else
		{               
			count++;
			byte=getbyte(infile);
		}		       							
    }
	if(feof(infile)==0)
		return(byte);
	else                 
	{
		printf("help help\n");
		return(0);
	}
}



//
// Normalize_Sound(infile,outfile,info) - This takes the .wav data
//		pointed to by infile and converts it to a mono, 8khz raw file
//		which is sent to outfile.
//
int  
Normalize_Sound(infile,outfile,info,size)
FILE			*infile;
FILE			*outfile;
WAVEFORMATEX 	*info;
DWORD			size;
{
int		ret,eof=0;    
BYTE	byte;
DWORD	fixup;
	//
	// Convert while we have data	     
	//     	

	while((feof(infile)==0) && ((size-fixup)>count))
	{
		switch((DWORD)(info->nSamplesPerSec & 0xffffff00))
		{
		case 0x0002b00:
			//
			// Convert 11khz to 8khz
			//  	We do this by taking 3 bytes, then dropping one.
			//	
			fixup=4;
			byte=get_sound_byte(infile,info);
			printf("%.2x\n",byte);
			byte=get_sound_byte(infile,info);
			printf("%.2x\n",byte);
			byte=get_sound_byte(infile,info);
			printf("%.2x\n",byte);
			get_sound_byte(infile,info);						// this byte just gets tossed.						
			break;
		case 0x0005600:
			//
			// Convert 11khz to 8khz
			//  	We do this by taking 3 bytes every 8 bytes.
			//	  	We take byte 0 byte 3 and byte 6 of every 8 bytes;
			//      
			fixup=8; 
			printf("%.2x\n",get_sound_byte(infile,info)); 	// keep byte 0
			get_sound_byte(infile,info);								// dump byte 1
			get_sound_byte(infile,info);						        // dump byte 2
			byte=get_sound_byte(infile,info);
			printf("%.2x\n",byte); 	// keep byte 3
			get_sound_byte(infile,info);								// dump byte 4
			get_sound_byte(infile,info);						        // dump byte 5
			byte=get_sound_byte(infile,info);			
			printf("%.2x\n",byte); 	// keep byte 6
			get_sound_byte(infile,info);								// dump byte 7
			break;
		case 0x000ac00:
			//
			// Convert 44khz to 8khz
			//  	We do this by taking 3 bytes from every 16.
			//		We take bytes 0, 5 and 11
			//	    
			fixup=16;
			printf("%.2x\n",get_sound_byte(infile,info)); 	// keep byte 0
			get_sound_byte(infile,info);								// dump byte 1
			get_sound_byte(infile,info);						        // dump byte 2
			get_sound_byte(infile,info);								// dump byte 3
			get_sound_byte(infile,info);								// dump byte 4			
			printf("%.2x\n",get_sound_byte(infile,info)); 	// keep byte 5
			get_sound_byte(infile,info);								// dump byte 6
			get_sound_byte(infile,info);						        // dump byte 7
			get_sound_byte(infile,info);								// dump byte 8
			get_sound_byte(infile,info);								// dump byte 9			
			get_sound_byte(infile,info);								// dump byte 10   
			printf("%.2x\n",get_sound_byte(infile,info)); 	// keep byte 11	
			get_sound_byte(infile,info);								// dump byte 12
			get_sound_byte(infile,info);						        // dump byte 13
			get_sound_byte(infile,info);								// dump byte 14
			get_sound_byte(infile,info);								// dump byte 15			
			break;
		default: 
			printf("Sample Rate %ld Not Supported\n",info->nSamplesPerSec);
			return -1;
		break;	
		}		
	}               
	return(ret);
}  
  





