//------------------------------------------------------------------------------
// downsamp.c
//
// Mike Johnson	iReady
//------------------------------------------------------------------------------          
#include <stdio.h>
#include "wave.h"

//
// Sample Rate Conversion Chart
//
char	eleven[] 	 =  {1,0,1,1,0,1,1,1,0,1,1,1,0,1,1,0,1,1,1,0,1,1,
					     1,0,1,1,0,1,1,1,0,1,1,1,0,1,1,0,1,1,1,0,1,1};
char	sixteen[]	 =  {1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,
					     1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0};
char	twentytwo[]  = 	{1,0,1,0,0,1,0,0,1,0,0,1,0,1,0,0,1,0,0,1,0,0,
						 1,0,1,0,0,1,0,0,1,0,0,1,0,1,0,0,1,0,0,1,0,0};
char	fourtyfour[] =  {1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,
					     1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0};
																					


BYTE
getbyte(file)
FILE	*file;
{
BYTE	b;

	if(feof(file)==0)
	{
		b=fgetc(file);
		return(b);
	}
	else
		return(0);	
}                 

WORD
getword(file)
FILE	*file;
{
char		*ptr;
WORD		store;

	ptr=(char *)&store;

	if(feof(file)==0)
		*ptr++=fgetc(file);
	else
		*ptr++=0;

    if(feof(file)==0)
        *ptr++=fgetc(file);
    else
        *ptr++=0; 

#ifdef SPARC
		store=swap(store);
#endif

	return(store);
}


DWORD	count=0;    
    
const BYTE
get_sound_byte(infile,info)
FILE			*infile;          
WAVEFORMATEX	*info;
{
WORD		temp;
BYTE		byte,byte1,byte2;
    //
    // Check for stereo
    //
	if(info->nChannels==2)
	{                  
		//
		// we are stereo, now check for 16 or 8 bits per sample
		//
		if(info->wBitsPerSample==16)
		{       
			count=count+4;
			//
			// 16 bits per sample, grab samples and convert to 8 bit then
			//		mono.
			//
			temp=(getword(infile) ^ 0x8000) ; 	// convert to linear
			byte1=(BYTE)( ((temp>>8) + ((temp<<7)&0x1)) &0xff);
			// convert 2nd sample to 8 bit
			temp=(getword(infile) ^ 0x8000) ; 	// convert to linear
			byte2=(BYTE)( ((temp>>8) + ((temp<<7)&0x1)) &0xff);
			// convet to mono			             
			temp=((WORD)byte1+(WORD)byte2)/2;
            		byte=(BYTE)temp;
		}
		else if(info->wBitsPerSample==8)
		{                 
			count=count+2;
			byte1=getbyte(infile);
			byte2=getbyte(infile);		
			// convet to mono			             
			temp=((WORD)byte1+(WORD)byte2)/2;
			byte=(BYTE)temp;
		}
	} 
	else 
	{	
		if(info->wBitsPerSample==16)
		{                 
			count=count+2;
			//
			// 16 bits per sample, grab sample and convert to 8 bit then
			//		mono.
			//
			temp=(getword(infile) ^ 0x8000) ; 	// convert to linear
			byte=(BYTE)( ((temp>>8) + ((temp<<7)&0x1)) &0xff);
		}
		else
		{               
			count++;
			byte=getbyte(infile);
		}		       							
    }
	if(feof(infile)==0)
		return(byte);
	else                 
	{
		printf("help help\n");
		return(0);
	}
}



//
// Normalize_Sound(infile,outfile,info) - This takes the .wav data
//		pointed to by infile and converts it to a mono, 8khz raw file
//		which is sent to outfile.
//
int  
Normalize_Sound(infile,outfile,info,size)
FILE			*infile;
FILE			*outfile;
WAVEFORMATEX 	*info;
DWORD			size;
{
int	ret,eof=0;
int		index;    
BYTE	byte;
DWORD	fixup;
	//
	// Convert while we have data	     
	//     	
	index=0;
	while((feof(infile)==0) && ((size-fixup)>count))
	{
		switch((DWORD)(info->nSamplesPerSec & 0xffffff00))
		{     
		case 0x0001f00:
			//
			// No conversion, file is 8khz.
			//                             
			fixup=0;
			byte=get_sound_byte(infile,info);
			printf("%.2x\n",byte);
			break;
		case 0x0002b00:
			//
			// Convert 11khz to 8khz
			//  	Using new tables   
			//	                       
			fixup=0; 
			byte=get_sound_byte(infile,info);			
            if(eleven[index]!=0)
					printf("%.2x\n",byte);    
			index++;
			if(index>43)
				index=0;
			break;
		case 0x0003e00:
			//
			// Convert 16khz to 8khz
			//  	Using new tables   
			//	                       
			fixup=0; 
			byte=get_sound_byte(infile,info);			
            if(sixteen[index]!=0)
					printf("%.2x\n",byte);    
			index++;
			if(index>43)
				index=0;
			break;
		case 0x0005600:
			//
			// Convert 22khz to 8khz
			//  	Using new tables   
			//	                       
			fixup=0; 
			byte=get_sound_byte(infile,info);			
            if(twentytwo[index]!=0)
					printf("%.2x\n",byte);    
			index++;
			if(index>43)
				index=0;
			
			break;
		case 0x000ac00:
			//
			// Convert 44khz to 8khz
			//  	Using new tables   
			//	                       
			fixup=0; 
			byte=get_sound_byte(infile,info);			
            if(fourtyfour[index]!=0)
					printf("%.2x\n",byte);    
			index++;
			if(index>43)
				index=0;
			
			break;
		default: 
			printf("Sample Rate %ld Not Supported\n",info->nSamplesPerSec);
			return -1;
		break;	
		}		
	}               
	return(ret);
}  
  





