//       												
// adpcm41u.c - uncompress adpcm 4:1	Mike Johnson	iReady
//                               
#include <stdio.h>
#include <string.h>
//
// step size and index for 4:1 ADPCM compression
//        			
int			step_count41=6;
int			step_size41[] 	= {0x01,0x02,0x04,0x08,0x10,0x20};
int			step_index41[6][2]	=  {0x00,0x01,
								0x01,0x03,
								0x02,0x06,
								0x04,0x0c,
								0x08,0x18,
								0x10,0x30};   

//
// readln_from_a_file
// 
int
readln_from_a_file(fp, line, size)
FILE    *fp;
char    *line;
int     size;
{
        char *p;
 
        do
                p = fgets( line, size, fp );
        while( ( p != NULL ) && ( *line == '#') );

        if( p == NULL )
                return( 0 );

        if (strchr(line, '\n'))
          *strchr(line, '\n') = '\0';
        if (strchr(line, '\r'))
          *strchr(line, '\r') = '\0';
        return( 1 );
}
 
 
//
//
//
main(argc,argv)
int 	argc;
char 	**argv;
{                    
char			line[25];
char			*filename;
int				go,j;
unsigned char	data;  
unsigned int	c;
int				cp=0;
int				ref_sample=0;
int				row_index=0;
int				step_delta=0;	
int				chunk=0;   
int				sign=0;
int				delta=0;  
         
	if(argc==1)
	{
		;
	}         
	else if (argc==2)
	{   
		if (!freopen(filename = argv[1], "rb", stdin)) 
		{
 			printf("\nError opening file %s.\n",filename);
  			exit(1);
  		}
    }
	else
	{             							
		printf("\nCorrect usage is: adpcm41u [file]\n");
		printf("	If file is not specified adpcm41u will use stdin.");  
		exit(1);
	}										

    //
    // First sample Initializes Uncompressor
    //  									                                  
    if(!readln_from_a_file(stdin, &line, 20))
    	exit(0);
    sscanf(line,"%x",&c);
    printf("%.2x\n",c);	
    //
    // Initialize Compressor
    //                      
    ref_sample=c;
	//
	// Start readling lines, each line should contain one sample
	//		
	go=1;									
	while(go)
	{                 
		//
		//
		//
		if(readln_from_a_file(stdin, &line, 20))
	    	sscanf(line,"%x",&c);
    	else         
			break;
		
		//
		// Process the compressed data chunks in the byte
		//
		for(j=4;j>0;j--)
		{       
			chunk = (c >> (2*(j-1))) & 0x03;
			cp=chunk & 0x01;
			if(chunk &0x2)
				ref_sample = ref_sample	- step_index41[row_index][cp];
			else
				ref_sample = ref_sample	+ step_index41[row_index][cp];
			//
			// Adjust Row Index
			//
			if(cp)
				row_index++;
			else
				row_index--;
			//
			// Clip Row Index
			//	
			if(row_index<0)
				row_index=0;
			if(row_index>(step_count41-1))
				row_index=step_count41-1;
			//
			// Store ref sample (clip to max values)
			//             
			if(ref_sample<0)
				data=0;
			else if(ref_sample>255)
				data=(unsigned char)0xff;
			else		    
				data=ref_sample;    
			//	
    		printf("%.2x\n",data);				
		}        						
	}
}