/****************************************************************************

    PROGRAM: sndtool.c

    PURPOSE: Sound Tool, for experimenting with sound compression.

	Mike Johnson iReady (c)1998

    FUNCTIONS:

        WinMain() - calls initialization function, processes message loop
        InitApplication() - initializes window data and registers window
        InitInstance() - saves instance handle and creates main window
        MainWndProc() - processes messages
        About() - processes messages for "About" dialog box

****************************************************************************/

#include "windows.h"
//#include <windows.h>
#include <mmsystem.h> 
#include <stdio.h>  
#include <string.h>	
#include "sndtool.h"
#include "commdlg.h"
#include "readwave.h"  
#include "compress.h"  
#include "downsamp.h"

HANDLE hInst;

HANDLE hAccTable;				/* handle to accelerator table */
HWND hEditWnd;					/* handle to edit window */
HWND hwnd;                      /* handle to main window */

/* new variables for common dialogs */
          
OPENFILENAME OrigConvFn; 
OPENFILENAME SaveConvFn;
OPENFILENAME OrigAscFn;
OPENFILENAME ofn;        
OPENFILENAME cfn;  
OPENFILENAME ucfn;     
OPENFILENAME WavFn;

char szFilterSpec [128] =                       /* file type filters */
             "WAV Files (*.wav)\0*.wav\0All Files (*.*)\0*.*\0";
char szFilterCloseCompress [128] =
              "ASCII COMP Files (*.acf)\0*.acf\0All Files (*.*)\0*.*\0";
char szFilterCloseUnCompress [128] =
              "ASCII UnCOMP Files (*.auf)\0*.auf\0All Files (*.*)\0*.*\0";                 
                                  
char ConvFileName[MAXFILENAME];                                  
char szFileName[MAXFILENAME];
char szFileTitle[MAXFILENAME];
char szOrigFileName[MAXFILENAME];
char szCompFileName[MAXFILENAME];
char szUnCompFileName[MAXFILENAME]; 
char szWavFileName[MAXFILENAME];
char aCurrentDir[80];     
char curdir[128];
 
char szBaseWindowTitle[] = "SndTool";
char szWindowTitle[80];    

char prefilter=0;
char postfilter=0;

    
/****************************************************************************

    FUNCTION: WinMain(HANDLE, HANDLE, LPSTR, int)

    PURPOSE: calls initialization function, processes message loop

****************************************************************************/

int PASCAL WinMain(hInstance, hPrevInstance, lpCmdLine, nCmdShow)
HANDLE hInstance;
HANDLE hPrevInstance;
LPSTR lpCmdLine;
int nCmdShow;
{
    MSG msg;     
    int i;

    if (!hPrevInstance)
        if (!InitApplication(hInstance))
            return (FALSE);

    if (!InitInstance(hInstance, nCmdShow))
        return (FALSE);

 																   
    
    while (GetMessage(&msg, NULL, NULL, NULL)) {

    /* Only translate message if it is not an accelerator message */

        if (!TranslateAccelerator(hwnd, hAccTable, &msg)) {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
    }
    return (msg.wParam);
}


/****************************************************************************

    FUNCTION: InitApplication(HANDLE)

    PURPOSE: Initializes window data and registers window class

****************************************************************************/

BOOL InitApplication(hInstance)
HANDLE hInstance;
{
    WNDCLASS  wc;

    wc.style = NULL;
    wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    //wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    wc.hIcon = LoadIcon(NULL, "IDI_IREADY");
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName =  "FileOpenMenu";
    wc.lpszClassName = "FileOpenWClass";

    return (RegisterClass(&wc));
}


/****************************************************************************

    FUNCTION:  InitInstance(HANDLE, int)

    PURPOSE:  Saves instance handle and creates main window

****************************************************************************/

BOOL InitInstance(hInstance, nCmdShow)
    HANDLE          hInstance;
    int             nCmdShow;
{
    RECT            Rect;    
    int				i;

    hInst = hInstance;

    hAccTable = LoadAccelerators(hInst, "FileOpenAcc");

    hwnd = CreateWindow(
        "FileOpenWClass",
        szBaseWindowTitle,
        WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        NULL,
        NULL,
        hInstance,
        NULL
    );

    if (!hwnd)
        return (FALSE);

    GetClientRect(hwnd, (LPRECT) &Rect);

    /* Create a child window */
#if 0
    hEditWnd = CreateWindow("Edit",
        NULL,
        WS_CHILD | WS_VISIBLE |
        /*ES_MULTILINE |*/ 0,
//        WS_VSCROLL | WS_HSCROLL |
//        ES_AUTOHSCROLL | ES_AUTOVSCROLL,
        0,
        0,
        (Rect.right-Rect.left),
        (Rect.bottom-Rect.top),
        hwnd,
        NULL/*IDC_EDIT*/,                          /* Child control i.d. */
        hInst,
        NULL);

    if (!hEditWnd) {
        DestroyWindow(hwnd);
        return (NULL);
    }
#endif
    //
    // fill in non-variant fields of OPENFILENAME struct.
    //													
    ofn.lStructSize       	= sizeof(OPENFILENAME);
    ofn.hwndOwner	  		= hwnd;
    ofn.lpstrFilter	 		= szFilterSpec;
    ofn.lpstrCustomFilter 	= NULL;
    ofn.nMaxCustFilter	  	= 0;
    ofn.nFilterIndex	  	= 1;
    ofn.lpstrFile         	= szFileName;
    ofn.nMaxFile	  		= MAXFILENAME;
    ofn.lpstrInitialDir   	= NULL;
    ofn.lpstrFileTitle    	= szFileTitle;
    ofn.nMaxFileTitle     	= MAXFILENAME;
    ofn.lpstrTitle        	= NULL;
    ofn.lpstrDefExt       	= "WAV";
    ofn.Flags             	= 0;                   
    
    OrigConvFn=SaveConvFn=OrigAscFn=WavFn=ucfn=cfn=ofn;  

    SaveConvFn.lpstrFile	=ConvFileName;
    SaveConvFn.lpstrDefExt	="auf"; 
    SaveConvFn.lpstrFilter	=szFilterCloseUnCompress;
    
    WavFn.lpstrFile			=szWavFileName;
    OrigAscFn.lpstrFile		=szOrigFileName;
    OrigAscFn.lpstrDefExt	="auf";
    OrigAscFn.lpstrFilter	=szFilterCloseUnCompress;
    ucfn.lpstrFile			=szUnCompFileName;
    ucfn.lpstrDefExt        ="auf";
    cfn.lpstrFile			=szCompFileName;
    cfn.lpstrDefExt        	="acf";    

	//
	// Calculate current working directory.                         															
    //
    GetModuleFileName(hInstance, &aCurrentDir, sizeof(aCurrentDir));
	i=strlen(aCurrentDir);
	while(i)
	{
		if(aCurrentDir[i]==0x5c)
		{
			aCurrentDir[i]=0;
			break;
		}         
		else
			i--;
	}
        

    
    ShowWindow(hwnd, nCmdShow);
    UpdateWindow(hwnd);
    return (TRUE);

}

/****************************************************************************

    FUNCTION: MainWndProc(HWND, UINT, WPARAM, LPARAM)

    PURPOSE:  Processes messages

    MESSAGES:

        WM_COMMAND    - application menu (About dialog box)
        WM_DESTROY    - destroy window

    COMMENTS:

        WM_COMMAND processing:

            IDM_OPEN - query to save current file if there is one and it
                       has been changed, open a new file.

            IDM_ABOUT - display "About" box.

****************************************************************************/

long FAR PASCAL __export MainWndProc(hWnd, message, wParam, lParam)
HWND hWnd;
UINT message;
WPARAM wParam;
LPARAM lParam;
{       
HMENU				hMenu;
static int			sVPos;       	// Position of Vertical scrollbar slider
static int			sHPos;   		// Position of Horizontal scrollbar slider
static long			sample_size; 
static SOUND		sound;     
static SOUND		tsound;
char				tstr[128]; 
char				outstr[255];
HDC					hdc;
PAINTSTRUCT			ps;
HPEN				hPen,hPenOld;
FARPROC 			lpProcAbout;
static int			i=0;
RECT				rect; 
int					tval;     


static long			scroll_max;
static long			scroll_step;
static int			scroll_page;
			
    switch (message) 
	{
   	case WM_CREATE:             
   		memset(&sound,0,sizeof(SOUND));
   		memset(&tsound,0,sizeof(SOUND));
   		scroll_max=0;   
   		sound.data_size=0;  
   		scroll_step=1;
   		SetScrollRange(hWnd, SB_HORZ, 0, 0, FALSE);
  		break;	
  									
   	case WM_COMMAND:
   			
   			hMenu = GetMenu(hWnd);
   			
            switch (wParam) 
            {
                case IDM_ABOUT:
                    lpProcAbout = MakeProcInstance(About, hInst);
                    DialogBox(hInst, "AboutBox", hWnd, lpProcAbout);
                    FreeProcInstance(lpProcAbout);
                    break;
                    
	            case IDM_SHOWWAVE:          
    				//
    				// Show the wave file info
    				//
					strcpy(outstr,"Parameter		Original	Normalized\n");
				
					sprintf(tstr, "Sample Rate	%-8lu	%-8lu bps\n",
						sound.oformat.nSamplesPerSec,sound.format.nSamplesPerSec);
					strcat(outstr,tstr);                               
					//
					sprintf(tstr, "Num Channels	%-8u	%-8u\n",
						sound.oformat.nChannels,sound.format.nChannels);
					strcat(outstr,tstr);   
					//
					sprintf(tstr, "BitsPerSamp	%-8u	%-8u\n",
						sound.oformat.wBitsPerSample,sound.format.wBitsPerSample);
					strcat(outstr,tstr);   
					//
					sprintf(tstr, "AvgBytesSec	%-8lu	%-8lu\n",
						sound.oformat.nAvgBytesPerSec,sound.format.nAvgBytesPerSec);
					strcat(outstr,tstr);   
					//
					sprintf(tstr, "BlockAlign	%-8u	%-8u\n",
						sound.oformat.nBlockAlign,sound.format.nBlockAlign);
					strcat(outstr,tstr);   
					//
					sprintf(tstr, "Sample Size	%-8lu	%-8lu bytes\n",
						sound.odata_size,sound.data_size);
					strcat(outstr,tstr);   

					MessageBox(hWnd, outstr,
                   			"Wave File Info", MB_OK);                	
                	break;
                
                case IDM_OPEN:
                    //
                    // Use standard open dialog 
                    //	
 		    		if (!GetOpenFileName ((LPOPENFILENAME)&ofn))
						return FALSE;    
					//
					// grey the save menu items.
					//                          
					EnableMenuItem(hMenu,IDM_SAVE,MF_GRAYED); 
					EnableMenuItem(hMenu,IDM_SAVEAS,MF_GRAYED);					
					EnableMenuItem(hMenu,IDM_SAVEORIGASCII,MF_GRAYED);	
					EnableMenuItem(hMenu,IDM_PLAYCOMP,MF_GRAYED);	
					EnableMenuItem(hMenu,IDM_PLAYCOMP1,MF_GRAYED);
					EnableMenuItem(hMenu,IDM_SAVEWAV,MF_GRAYED);
					EnableMenuItem(hMenu,IDM_SHOWWAVE,MF_GRAYED);	
					EnableMenuItem(hMenu,IDM_PLAYORIG1,MF_GRAYED);
					EnableMenuItem(hMenu,IDM_PLAYORIG,MF_GRAYED);	
					EnableMenuItem(hMenu,IDM_COMPRESS1,MF_GRAYED);
					EnableMenuItem(hMenu,IDM_COMPRESS2,MF_GRAYED);
					EnableMenuItem(hMenu,IDM_COMPRESS15,MF_GRAYED);
					EnableMenuItem(hMenu,IDM_COMPRESS16,MF_GRAYED);	
					EnableMenuItem(hMenu,IDM_COMPRESS17,MF_GRAYED);		
					EnableMenuItem(hMenu,IDM_COMPRESS18,MF_GRAYED);				
                    //
                    // Clean savefile names
                    //
                    szUnCompFileName[0]=0;
                    szCompFileName[0]=0;   
                    szOrigFileName[0]=0;
                    szWavFileName[0]=0;
                    //
                    // Cleanup any Previously loaded data.
                    //
					Cleanup_Sound(&sound);
                    //
                    // Try to read the wav file
                    //                         
                    if(!Read_Wave(hWnd,szFileName,&sound))
                    	return FALSE;
				     
				    Normalize_Sound(&sound);
				     
					//if(Normalize_Sound(&sound))
					//	return FALSE;
					
					//
					// Set the file as open
					//                    
                    lstrcpy(szWindowTitle, szBaseWindowTitle);
                    lstrcat(szWindowTitle, " - ");
                    lstrcat(szWindowTitle, szFileTitle); 
                    sprintf(tstr," [%d bit]",sound.format.wBitsPerSample);
                    lstrcat(szWindowTitle,tstr);
                    SetWindowText(hWnd, szWindowTitle); 
                    //
                    // Set the scroll range with new size
                    //
                    GetClientRect(hwnd,&rect);
					scroll_max=(long)sound.data_size-rect.right;            		
                    scroll_page=rect.right/2;
                    if(scroll_max<0)
                    	scroll_max=0;	
                    if(scroll_max>30000)
                    {                				
                    	scroll_step=(scroll_max/30000)+1;
                    	scroll_max=scroll_max/scroll_step;							
                    }
                    SetScrollRange(hWnd, SB_HORZ, 0, (int) scroll_max, TRUE);    
                    sHPos=1;
					//
					// Enable the save original as ascii option
					//
					EnableMenuItem(hMenu,IDM_SAVEORIGASCII,MF_ENABLED);	
					EnableMenuItem(hMenu,IDM_SHOWWAVE,MF_ENABLED);	
					EnableMenuItem(hMenu,IDM_PLAYORIG,MF_ENABLED);	
					EnableMenuItem(hMenu,IDM_PLAYORIG1,MF_ENABLED);
					EnableMenuItem(hMenu,IDM_COMPRESS1,MF_ENABLED);	
					EnableMenuItem(hMenu,IDM_COMPRESS2,MF_ENABLED);	
					EnableMenuItem(hMenu,IDM_COMPRESS15,MF_ENABLED);	
					EnableMenuItem(hMenu,IDM_COMPRESS16,MF_ENABLED);	  
					EnableMenuItem(hMenu,IDM_COMPRESS17,MF_ENABLED);					
					//
	        		// Force redraw
	        		//
	        		DrawMenuBar(hWnd);
	        		InvalidateRect(hWnd,NULL,TRUE);
		            break;           
                case ID_FILE_OPENAUFFILE:
                    //
                    // Use standard open dialog 
                    //							
		    		if (!GetOpenFileName ((LPOPENFILENAME)&OrigAscFn))
						return FALSE;    
					//
					// grey the save menu items.
					//                          
					EnableMenuItem(hMenu,IDM_SAVE,MF_GRAYED); 
					EnableMenuItem(hMenu,IDM_SAVEAS,MF_GRAYED);					
					EnableMenuItem(hMenu,IDM_SAVEORIGASCII,MF_GRAYED);	
					EnableMenuItem(hMenu,IDM_PLAYCOMP,MF_GRAYED);	
					EnableMenuItem(hMenu,IDM_PLAYCOMP1,MF_GRAYED);
					EnableMenuItem(hMenu,IDM_SAVEWAV,MF_GRAYED);
					EnableMenuItem(hMenu,IDM_SHOWWAVE,MF_GRAYED);	
					EnableMenuItem(hMenu,IDM_PLAYORIG,MF_GRAYED);	
					EnableMenuItem(hMenu,IDM_PLAYORIG1,MF_GRAYED);
					EnableMenuItem(hMenu,IDM_COMPRESS1,MF_GRAYED);
					EnableMenuItem(hMenu,IDM_COMPRESS2,MF_GRAYED);
					EnableMenuItem(hMenu,IDM_COMPRESS15,MF_GRAYED);
					EnableMenuItem(hMenu,IDM_COMPRESS16,MF_GRAYED);	
					EnableMenuItem(hMenu,IDM_COMPRESS17,MF_GRAYED);
					EnableMenuItem(hMenu,IDM_COMPRESS18,MF_GRAYED);										
                    //
                    // Clean savefile names
                    //
                    szUnCompFileName[0]=0;
                    szCompFileName[0]=0;   
                    szWavFileName[0]=0;
                    //
                    // Cleanup any Previously loaded data.
                    //
					Cleanup_Sound(&sound);
                    //
                    // Try to read the wav file
                    //                         
                    if(!Read_AUF(hWnd,szOrigFileName,&sound))
                    	return FALSE;
					//
					// Set the file as open
					//                    
                    lstrcpy(szWindowTitle, szBaseWindowTitle);
                    lstrcat(szWindowTitle, " - ");
                    lstrcat(szWindowTitle, szFileTitle); 
                    sprintf(tstr," [%d bit]",sound.format.wBitsPerSample);
                    lstrcat(szWindowTitle,tstr);
                    SetWindowText(hWnd, szWindowTitle); 
                    //
                    // Set the scroll range with new size
                    //
                    GetClientRect(hwnd,&rect);
					scroll_max=(long)sound.data_size-rect.right;            		
                    scroll_page=rect.right/2;
                    if(scroll_max<0)
                    	scroll_max=0;	
                    if(scroll_max>30000)
                    {                				
                    	scroll_step=(scroll_max/30000)+1;
                    	scroll_max=scroll_max/scroll_step;							
                    }
                    SetScrollRange(hWnd, SB_HORZ, 0, (int) scroll_max, TRUE);    
                    sHPos=1;
					//
					// Enable the save original as ascii option
					//
					EnableMenuItem(hMenu,IDM_SAVEORIGASCII,MF_ENABLED);	
					EnableMenuItem(hMenu,IDM_SHOWWAVE,MF_ENABLED);	
					EnableMenuItem(hMenu,IDM_PLAYORIG,MF_ENABLED);	
					EnableMenuItem(hMenu,IDM_PLAYORIG1,MF_ENABLED);
					EnableMenuItem(hMenu,IDM_COMPRESS1,MF_ENABLED);	
					EnableMenuItem(hMenu,IDM_COMPRESS2,MF_ENABLED);
					EnableMenuItem(hMenu,IDM_COMPRESS15,MF_ENABLED);	
					EnableMenuItem(hMenu,IDM_COMPRESS16,MF_ENABLED);	     
					EnableMenuItem(hMenu,IDM_COMPRESS17,MF_ENABLED);					
					//
	        		// Force redraw
	        		//
	        		DrawMenuBar(hWnd);
	        		InvalidateRect(hMenu,NULL,TRUE);
	        		InvalidateRect(hWnd,NULL,TRUE);
		            break;           

        		case IDM_CONVERTWAVETOASCII:
                    //
                    // Use standard open dialog 
                    //							
		    		if (!GetOpenFileName ((LPOPENFILENAME)&OrigConvFn))
						return FALSE;               
						
                    if(!Read_Wave(hWnd,szFileName/*ConvFileName*/,&tsound))
                    	return FALSE;
                    
                    ConvFileName[0]=0;
                    
                    if (!GetSaveFileName ((LPOPENFILENAME)&SaveConvFn))
						return FALSE;

					SaveFileASCII(ConvFileName,tsound.data,tsound.data_size);
                    //
                    // Cleanup any Previously loaded data.
                    //
					Cleanup_Sound(&tsound);
					break;

	            case IDM_SAVEORIGASCII:   
                    //
                    // Change the filter to save compressed filter
                    //
    				OrigAscFn.lpstrFilter	=szFilterCloseUnCompress;
                    //
                    // Change the default save file extention if wav
                    //                                       
                    if (!GetSaveFileName ((LPOPENFILENAME)&OrigAscFn))
						return FALSE;

					SaveFileASCII(szOrigFileName,sound.data,sound.data_size);
                    break;
                case IDM_SAVECOMPRESSED:
                    //
                    // Change the filter to save compressed filter
                    //
                    cfn.lpstrFilter		= szFilterCloseCompress;
                     //
                    // Change the default save file extention if wav
                    //                                       
                    
                    if (!GetSaveFileName ((LPOPENFILENAME)&cfn))
						return FALSE;

					SaveFileASCII(szCompFileName,sound.cdata,sound.cdata_size);

                    break;

                case IDM_SAVEUNCOMPRESSED:    
                    //
                    // Setup for an uncompressed save
                    //
                    ucfn.lpstrFilter		= szFilterCloseUnCompress;   
                    //
                    if (!GetSaveFileName ((LPOPENFILENAME)&ucfn))
						return FALSE;

					SaveFileASCII(szUnCompFileName,sound.ucdata,sound.ucdata_size);

                	break;              
                case IDM_SAVEWAV:
	                //
                    // Setup for an uncompressed save
                    //
                    WavFn.lpstrFilter		= szFilterSpec;   
                    //
                    if (!GetSaveFileName ((LPOPENFILENAME)&WavFn))
						return FALSE;

					SaveFileWav(szWavFileName,sound.ucdata,sound.ucdata_size);

                	break;              
				case IDM_NEW:
                   	break;
                case IDM_EXIT:
                    DestroyWindow(hWnd);
                    break;
                
                case IDM_PLAYORIG1:
                case IDM_PLAYORIG:
                	Play_Sound(hWnd,&sound,0);
                	break;         
                case IDM_PLAYCOMP1:	
				case IDM_PLAYCOMP:
                	Play_Sound(hWnd,&sound,1);
                	break;
                //
                // Prefiler/Postfilter toggles
                //	                         
                case IDM_PREFILTER:    
                	if(prefilter==1)
                	{              												
						ModifyMenu(hMenu, 
								IDM_PREFILTER, 
								MF_BYCOMMAND | MF_STRING, 
								IDM_PREFILTER,
								"Turn Prefilter ON");
                		prefilter=0;
                	}
                	else            
                	{
						ModifyMenu(hMenu, IDM_PREFILTER, 
							MF_BYCOMMAND | MF_STRING, 
							IDM_PREFILTER, 
							"Turn Prefilter OFF");
						prefilter=1;
                	}
                	DrawMenuBar(hWnd);
                	break;
                case IDM_POSTFILTER:
                	if(postfilter==1)
                	{       				       												
						ModifyMenu(hMenu, 
								IDM_POSTFILTER, 
								MF_STRING | MF_BYCOMMAND, 
								IDM_POSTFILTER,
								"Turn Postfilter ON");
                		postfilter=0;
                	}
                	else            
                	{
						ModifyMenu(hMenu, IDM_POSTFILTER, 
							MF_STRING | MF_BYCOMMAND, 
							IDM_POSTFILTER, 
							"Turn Postfilter OFF");
						postfilter=1;
                	}
                	DrawMenuBar(hWnd);
                	break;
                //
                // 4:1 soundblaster ADPCM
                //
                case IDM_COMPRESS1:
                    if(!Compress_ADPCM41_6row(hWnd,&sound,prefilter,postfilter))
                    {
						MessageBox(hWnd, "Error on Compress",
                   			NULL, MB_OK | MB_ICONEXCLAMATION);
						break;                        
                    }          
					//
					// Enable the save menu items.
					//                          
					EnableMenuItem(hMenu,IDM_SAVE,MF_ENABLED); 
					EnableMenuItem(hMenu,IDM_SAVEAS,MF_ENABLED);				
					EnableMenuItem(hMenu,IDM_PLAYCOMP,MF_ENABLED);
					EnableMenuItem(hMenu,IDM_PLAYCOMP1,MF_ENABLED);
					EnableMenuItem(hMenu,IDM_SAVEWAV,MF_ENABLED);
					//
                    lstrcpy(szWindowTitle, szBaseWindowTitle);
                    lstrcat(szWindowTitle, " - ");
                    lstrcat(szWindowTitle, szFileTitle);
					sprintf(tstr," - ADPCM 4:1 S/N = %8.3lf radio %d:1",
						snr(sound.data,sound.ucdata,sound.ucdata_size),
							(sound.data_size+20)/sound.cdata_size); 						
                    lstrcat(szWindowTitle,tstr);
                    SetWindowText(hWnd, szWindowTitle);
	        		//
	        		// Force redraw
	        		//
	        		DrawMenuBar(hWnd);
	        		InvalidateRect(hWnd,NULL,TRUE);
                    
                	break;	
                //
                // 2:1 soundblaster ADPCM
                //
                case IDM_COMPRESS2:
                    if(!Compress_ADPCM21(hWnd,&sound,prefilter,postfilter))
                    {
						MessageBox(hWnd, "No Data to Compress",
                   			NULL, MB_OK | MB_ICONEXCLAMATION);
						break;                        
                    }          
					//
					// Enable the save menu items.
					//                          
					EnableMenuItem(hMenu,IDM_SAVE,MF_ENABLED); 
					EnableMenuItem(hMenu,IDM_SAVEAS,MF_ENABLED);				
					EnableMenuItem(hMenu,IDM_PLAYCOMP,MF_ENABLED);
					EnableMenuItem(hMenu,IDM_PLAYCOMP1,MF_ENABLED);
					EnableMenuItem(hMenu,IDM_SAVEWAV,MF_ENABLED);
					//
                    lstrcpy(szWindowTitle, szBaseWindowTitle);
                    lstrcat(szWindowTitle, " - ");
                    lstrcat(szWindowTitle, szFileTitle);
					sprintf(tstr," - ADPCM 2:1 S/N = %8.3lf radio %d:1",
						snr(sound.data,sound.ucdata,sound.ucdata_size),
							(sound.data_size+50)/sound.cdata_size); 						
                    lstrcat(szWindowTitle,tstr);
                    SetWindowText(hWnd, szWindowTitle);
	        		//
	        		// Force redraw
	        		//
	        		DrawMenuBar(hWnd);
	        		InvalidateRect(hWnd,NULL,TRUE);
                    
                	break;	

				//
				//
				//				
				case IDM_COMPRESS15: 
					if(!Compress_ABC(hWnd,&sound,prefilter,postfilter,64,1))
 					{
						MessageBox(hWnd, "No Data to Compress",
                   			NULL, MB_OK | MB_ICONEXCLAMATION);
						break; 
					}
					//
					// Enable the save menu items.
					//                          
					EnableMenuItem(hMenu,IDM_SAVE,MF_ENABLED); 
					EnableMenuItem(hMenu,IDM_SAVEAS,MF_ENABLED);				
					EnableMenuItem(hMenu,IDM_PLAYCOMP,MF_ENABLED);
					EnableMenuItem(hMenu,IDM_PLAYCOMP1,MF_ENABLED);
					EnableMenuItem(hMenu,IDM_SAVEWAV,MF_ENABLED);
					//
                    lstrcpy(szWindowTitle, szBaseWindowTitle);
                    lstrcat(szWindowTitle, " - ");
                    lstrcat(szWindowTitle, szFileTitle);
					sprintf(tstr," - ABC2(64blk) S/N = %8.3lf radio %d:1",
						snr(sound.data,sound.ucdata,sound.ucdata_size),
							(sound.data_size+50)/sound.cdata_size); 						
                    lstrcat(szWindowTitle,tstr);
                    SetWindowText(hWnd, szWindowTitle);
	        		//
	        		// Force redraw
	        		//
	        		DrawMenuBar(hWnd);
	        		InvalidateRect(hWnd,NULL,TRUE);
	        		break;
				case IDM_COMPRESS16: 
					if(!Compress_ABC(hWnd,&sound,prefilter,postfilter,64,0))
 					{
						MessageBox(hWnd, "No Data to Compress",
                   			NULL, MB_OK | MB_ICONEXCLAMATION);
						break; 
					}                               
					//
					// Enable the save menu items.
					//                          
					EnableMenuItem(hMenu,IDM_SAVE,MF_ENABLED); 
					EnableMenuItem(hMenu,IDM_SAVEAS,MF_ENABLED);					
					EnableMenuItem(hMenu,IDM_PLAYCOMP,MF_ENABLED);
					EnableMenuItem(hMenu,IDM_PLAYCOMP1,MF_ENABLED);
					EnableMenuItem(hMenu,IDM_SAVEWAV,MF_ENABLED);					
					//					
                    lstrcpy(szWindowTitle, szBaseWindowTitle);
                    lstrcat(szWindowTitle, " - ");
                    lstrcat(szWindowTitle, szFileTitle);
					sprintf(tstr," - ABC3(128blk) S/N = %8.3lf radio %d:1",
						snr(sound.data,sound.ucdata,sound.ucdata_size),
							(sound.data_size+50)/sound.cdata_size); 						
                    lstrcat(szWindowTitle,tstr);
                    SetWindowText(hWnd, szWindowTitle);
	        		//
	        		// Force redraw
	        		//
	        		DrawMenuBar(hWnd);
	        		InvalidateRect(hWnd,NULL,TRUE);
	        		break;     
				case IDM_COMPRESS17:   
					if(!Compress_g726_32(hWnd, &sound, prefilter, postfilter))
					{
						MessageBox(hWnd, "No Data to Compress",
                   			NULL, MB_OK | MB_ICONEXCLAMATION);
						break; 
					}                               
					//
					// Enable the save menu items.
					//                          
					EnableMenuItem(hMenu,IDM_SAVE,MF_ENABLED); 
					EnableMenuItem(hMenu,IDM_SAVEAS,MF_ENABLED);					
					EnableMenuItem(hMenu,IDM_PLAYCOMP,MF_ENABLED);
					EnableMenuItem(hMenu,IDM_PLAYCOMP1,MF_ENABLED);
					EnableMenuItem(hMenu,IDM_SAVEWAV,MF_ENABLED);					
					//					
                    lstrcpy(szWindowTitle, szBaseWindowTitle);
                    lstrcat(szWindowTitle, " - ");
                    lstrcat(szWindowTitle, szFileTitle);
					sprintf(tstr," - ABC3(128blk) S/N = %8.3lf radio %d:1",
						snr(sound.data,sound.ucdata,sound.ucdata_size),
							(sound.data_size+50)/sound.cdata_size); 						
                    lstrcat(szWindowTitle,tstr);
                    SetWindowText(hWnd, szWindowTitle);
	        		//
	        		// Force redraw
	        		//
	        		DrawMenuBar(hWnd);
	        		InvalidateRect(hWnd,NULL,TRUE);
	        		break;	        		
	        		
                case IDM_CUT:
                case IDM_COPY:
                case IDM_PASTE:
                case IDM_CLEAR:
                    MessageBox (
                          GetFocus(),
                          "Command not implemented",
                          "FileOpen Sample Application",
                          MB_ICONASTERISK | MB_OK);
                    break;

                case IDC_EDIT:
                    if (HIWORD (lParam) == EN_ERRSPACE) {
                        MessageBox (
                              GetFocus ()
                            , "Out of memory."
                            , "FileOpen Sample Application"
                            , MB_ICONHAND | MB_OK
                        );
                    }
                    break;

            }
            break;

	    case WM_VSCROLL:
			break;
    	case WM_HSCROLL:
        	switch (wParam)
           	{
            case SB_LINEDOWN:
                 sHPos = min((int)scroll_max, sHPos + 1);
                 break;

            case SB_LINEUP:
                 sHPos = max(1, sHPos - 1);
                 break;

            case SB_THUMBPOSITION:
                 sHPos = LOWORD(lParam);
                 break;

            case SB_PAGEUP:
                 sHPos = max(1,(sHPos - (scroll_page/scroll_step)));
                 break;

            case SB_PAGEDOWN:
                 sHPos = min(scroll_max,(sHPos+(scroll_page/scroll_step)));
                 break;

            default:
                 return FALSE;
           	}
        	if(sHPos<1)
  				sHPos=1;
	  		if(sHPos>scroll_max)
  				sHPos=scroll_max;
 			InvalidateRect(hWnd,NULL,TRUE);
         	SetScrollPos(hWnd, SB_HORZ, sHPos, TRUE);
         	break;
        
        case WM_PAINT:
		{	

			int		midpoint;             
			int		data;
			
			GetClientRect(hwnd,&rect);
			midpoint=rect.bottom/2;
        	hdc = BeginPaint(hwnd, &ps);    
        	SetBkMode(hdc, OPAQUE);

			hPen=CreatePen(PS_SOLID,3,0L);
            hPenOld = SelectObject(hdc, hPen);
			MoveTo(hdc,0,midpoint);
			LineTo(hdc,rect.right,midpoint);
        	SelectObject(hdc,hPenOld);
			DeleteObject(hPen);
			//
			// Draw Compressed Waveform.
			//               
			if(sound.ucdata_size!=0)
			{         													
            	hPen = CreatePen(PS_SOLID,1,RGB(255,0,0));
            	hPenOld = SelectObject(hdc, hPen);				
				MoveTo(hdc,0,((unsigned char)sound.ucdata[sHPos*scroll_step]-127)+midpoint);
				data=sound.ucdata[sHPos*scroll_step];			
				for(i=0;i<rect.right;i++)
				{ 
					data=((unsigned char)sound.ucdata[i+(sHPos*scroll_step)])-127;
					tval=data+midpoint;
					if((tval>rect.top) && (tval < rect.bottom)) 
						LineTo(hdc,i,tval);
				}                               
	        	SelectObject(hdc,hPenOld);
				DeleteObject(hPen);
			}
			//
			// Draw Original Source Waveform.
			//               
			if(sound.data_size!=0)
			{    
            	hPen = CreatePen(PS_SOLID,1,0L);
            	hPenOld = SelectObject(hdc, hPen);				
				MoveTo(hdc,0,((unsigned char)sound.data[sHPos*scroll_step]-127)+midpoint);
				data=sound.data[sHPos*scroll_step];			
				for(i=0;i<rect.right;i++)
				{ 
					data=((unsigned char)sound.data[i+sHPos*scroll_step])-127;
					LineTo(hdc,i,data+midpoint);
				}
	        	SelectObject(hdc,hPenOld);
				DeleteObject(hPen);
			}
            //
            //
            //
        	EndPaint(hwnd, &ps);
           	return 0;
        }
        case WM_SETFOCUS:
            SetFocus (hEditWnd);
            break;

        case WM_SIZE:
            MoveWindow(hEditWnd, 0, 0, LOWORD(lParam), HIWORD(lParam), TRUE);
            InvalidateRect(hWnd,NULL,TRUE);
            break;

        case WM_DESTROY:  
        	Play_Sound_Cleanup();
        	Cleanup_Sound(&sound);
            PostQuitMessage(0);
            break;
    case MM_WOM_DONE:
        //
        // This message indicates a waveform data block has
        // been played and can be freed. Clean up the preparation
        // done previously on the header.
        //
        Play_Sound_Cleanup();
        //
        // Reenable both button controls.
        //
        //EnableWindow( hwndPlay, TRUE );
        //EnableWindow( hwndQuit, TRUE );
        //SetFocus(hwndName);
        break;

        default:
            return (DefWindowProc(hWnd, message, wParam, lParam));
    }
    return (TRUE);
}

/****************************************************************************

    FUNCTION: About(HWND, unsigned, WORD, LONG)

    PURPOSE:  Processes messages for "About" dialog box

    MESSAGES:

        WM_INITDIALOG - initialize dialog box
        WM_COMMAND    - Input received

****************************************************************************/

BOOL FAR PASCAL __export About(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
    switch (message) {
        case WM_INITDIALOG:
            return (TRUE);

        case WM_COMMAND:
	    if (wParam == IDOK
                || wParam == IDCANCEL) {
                EndDialog(hDlg, TRUE);
                return (TRUE);
            }
            break;
    }
    return (FALSE);
}
