//
// downsamp.c - Mike Johnson 1998 iready  and (c)1994 Mycal labs www.mycal.net
//          
#include "windows.h"
#include <mmsystem.h>  
#include "readwave.h"
#include "downsamp.h"




// NOTES:
//About the Actual Data (in the DATA CHUNK) 
//For an 8 bit mono sample, things are simple: 
//	each byte represents one sample. 
// For a stereo sample, one byte will be the left
//channel, and the next the right channel. 
//
//For a 16 bit sample, it's the same, but now each sample will be two bytes long, rather than just one byte. They're little-endian.  


//
//
//
int
sixteen_2_eight_bit(sound)
SOUND	*sound;					
{            
DWORD	i;
DWORD	temp;
HPSTR	data8;  
int _huge	*data16;

	if(sound->format.wBitsPerSample==16)
	{                
		data8=sound->data;
		data16=(int huge *)data8;
		//
		// Convert the 16 bit samples to 8 bit samples.  This is
		//	done by tossing away the 8 least significant bits, and
		//	adding in the MSB of the through away bits back into
		//	the 8 most significant bits.
		//
		for(i=0;i<(sound->data_size/2);i++)
		{
			temp=data16[i];
			//flip msb to convert to linear
			temp=(temp ^ 0x8000); // Convert to linear
			data8[i]=(BYTE)( ((temp>>8) + ((temp<<7)&0x1)) &0xff);
		}
        //
		// set the new format.
		//
		sound->format.wBitsPerSample=8;  
		sound->format.nBlockAlign/=2;
		sound->format.nAvgBytesPerSec/=2; 
		sound->data_size=sound->data_size/2;

		return 0;
    }
	else
		return-1;
} 
   
//
//
//
int   
stereo_2_mono(sound)
SOUND	*sound;
{     
DWORD	i,j;
WORD	temp;
BYTE _huge	*data8;

	if(sound->format.nChannels==2)
	{       
		data8=sound->data;
		//
		// Convert Stereo to Mono.  This is done by adding the two
		// channels togeather and dividing by 2.
		//
		for(i=0,j=0;i<sound->data_size-2;i+=2,j++)
		{
			temp=((WORD)data8[i]+(WORD)data8[i+1])/2;
			data8[j]=(BYTE)temp;       
		}																
		//
		// Set new Data size and number of channels
		//
		sound->format.nChannels=1;
		sound->format.nAvgBytesPerSec/=2; 
		sound->format.nBlockAlign/=2;
		sound->data_size/=2;
		return 0;				
	}
	else
		return -1;
} 
   
int   
eleven_2_eight(sound)
SOUND	*sound;
{  
unsigned long	i,j;
HPSTR	data8; 


	if((sound->format.nSamplesPerSec & 0xffffff00)==0x0002b00)
	{
		data8=sound->data;		
		//
		// Convert 11khz to 8khz
		//  	We do this by taking 2 bytes, then dropping one.
		//	
		for(i=0,j=0;j<sound->data_size-2;i+=2,j+=3)
		{
			data8[i]=data8[j];
			data8[i+1]=data8[j+1];
		}		
        //
        // Set samples per second
        //
        sound->data_size=i;
        sound->format.nAvgBytesPerSec=													
		sound->format.nSamplesPerSec=7350;	
	}
	else
		return 1;
}

int
twentytwo_2_eight(sound)
SOUND	*sound;
{             
unsigned long	i,j;
HPSTR	data8;

	if((sound->format.nSamplesPerSec & 0xffffff00)==0x0005600)
	{
		data8=sound->data;		
		//
		// Convert 11khz to 8khz
		//  	We do this by taking 1 byte, then dropping two.
		//	
		for(i=0,j=0;j<sound->data_size-3;i+=1,j+=3)
		{
			data8[i]=data8[j];
		}	
		//
		// Set Samples Per Second
		//	
		sound->data_size=i;
		sound->format.nAvgBytesPerSec=
		sound->format.nSamplesPerSec=7350;														

	}
	else
		return 1;
	
	return -1;
}

int
fourtyfour_2_eight(sound)
SOUND	*sound;
{
unsigned long	i,j;
HPSTR	data8;

	if((sound->format.nSamplesPerSec & 0xffffff00)==0x000ac00)
	{
		data8=sound->data;		
		//
		// Convert 44khz to 8khz
		//  	We do this by taking 1 bytes, then dropping 4.
		//	
		for(i=0,j=0;i<sound->data_size-2;i+=1,j+=5)
		{
			data8[i]=data8[j];
		}		
		//
		// Set Samples Per Second
		//
		sound->format.nAvgBytesPerSec=
		sound->format.nSamplesPerSec=8000;		
		sound->data_size=i;												
	}
	else
		return 1;

	return -1;
}

//
// Order for normalize  16bit to 8bit
//						Stereo to Mono
//						Rate Conversion
//
//
int  
Normalize_Sound(sound)
SOUND	*sound;
{
int	ret;
	//
	// Based on sample Rate
	//  	and top 24 bits.
	//0x0002b000 = 11 to 8
	//0x00056000 = 22 to 8
	//0x000ac000 = 44 to 8
	//sound-> ->	nSamplesPerSec;
	//	        
	ret=0;
	ret=sixteen_2_eight_bit(sound);
	ret|=stereo_2_mono(sound);

	switch((DWORD)(sound->format.nSamplesPerSec & 0xffffff00))
	{
	case 0x0002b00:
		ret|=eleven_2_eight(sound);
		break;
	case 0x0005600:
		ret|=twentytwo_2_eight(sound);
		break;
	case 0x000ac00:
		ret|=fourtyfour_2_eight(sound);
		break;
	default:
		return 1;
	break;			
	}

	return(ret);
}  
  





