//
// Filters.c - Mike Johnson 1998 iready  and (c)1994 Mycal labs www.mycal.net
//          
#include <windows.h>
#include <mmsystem.h>
#include <stdlib.h>	  
#include <math.h>
///-------------------------------------------
/// Simple lowpass filter using divides
/// 
void
lowpass1(data,len)
HPSTR	data;
long	len;
{
    long i;
    unsigned int	a,b,c;    
        
    a=b=c=0x80;
    for(i=0;i<len-1;i++)
    {
		a=b;
		b=c;
		c=(unsigned char)data[i];
						
		data[i]=(a+(b<<1)+c)>>2;	

    }
}

void
lowpass1_copy(data,sdata,len)
HPSTR	data;
HPSTR	sdata;
long	len;
{
    long i;
	unsigned int	a,b,c;                                 
                                 
    
    a=b=c=0x80;
    
    for(i=0;i<len;i++)
    {                
		a=b;
		b=c;
		c=(unsigned char)sdata[i];
		
		data[i]=(a+(b<<1)+c)>>2;
    }
}
     
     
#if 0
///-------------------------------------------
/// Simple lowpass filter using divides
/// 
void
lowpass1(data,len)
HPSTR	data;
long	len;
{
    long i;
    unsigned char    t,tt,last;
    unsigned int	a,b,c;    
        
    tt=0x80;
    for(i=0;i<len-1;i++)
    {
        t=data[i];   
        if((i+1)<=len)
        	last=(unsigned char)data[i+1];
        else
        	last=0x80;
        		                       						
		a=tt;
		b=(unsigned char)data[i];
		c=(unsigned char)last;
		
		data[i]=(a+(b<<1)+c)>>2;	
		//data[i] = (((unsigned char)tt)/4) + (((unsigned char)data[i])/2) 
        //			+ (((unsigned char)data[i+1])/4);
        tt=t;
    }
}

void
lowpass1_copy(data,sdata,len)
HPSTR	data;
HPSTR	sdata;
long	len;
{
    long i;
    
    unsigned char	t,tt,last;
                                 
	unsigned int	a,b,c;                                 
                                 
    
    tt=0x80;
    
    for(i=0;i<len;i++)
    {                
    	if((i+1)<len)
    		last=(unsigned char)sdata[i+1];
    	else
    		last=0x80;	
        
        t=sdata[i];                             
		                  
		a=tt;
		b=(unsigned char)sdata[i];
		c=(unsigned char)last;
		
		data[i]=(a+(b<<1)+c)>>2;	
		//data[i]=((a>>1)+(b)+(c>>1))>>1;		 
		//data[i]=((a/4)+(b/2)+(c/4));	                                    
		//        data[i] = (unsigned char)((((unsigned int)tt)>>1) + (((unsigned int)sdata[i])) 
       	// 			+ (((unsigned int)last)>>1)>>1);
	
		tt=t;
    }
}
    
///
/// Simple lowpass filter using shifts
/// 
void
lowpass2(data,len)
HPSTR	data;
long     len;
{
    long i;
    unsigned char    t,tt;

    tt=data[0];
    for(i=1;i<len-1;i++)
    {
        t=data[i];  																
        data[i] = (((unsigned char)tt)>>2) + (((unsigned char)data[i])>>1) +
        		 (((unsigned char)data[i+1])>>2);
        tt=t;
    }
}    
 

//
//
// 
void
lowpass3(data,len)
HPSTR    *data;
LONG     len;
{
    long i;
    unsigned char s1,t1;

    t1=(unsigned char)data[0];
    s1=(unsigned char)data[1];
    for(i=2;i<len-2;i++)
    {
/*        t2=(unsigned char)data[i-2];
        s2=(unsigned char)data[i-1];
        data[i] =(unsigned char)((float)t1*-.0857 +(float)s1*.3428 +
                (.4857 * (float)data[i])+ (.3428 * (float)data[i+1]) +
                (-.0857*(float)data[i+2]));
        t1=t2;
        s1=s2;
*/
    }
}
 
void 
lowpass4(data,len)
HPSTR    *data;
LONG     len;
{
    long i;
    unsigned char s1,t1,s2,t2,s3,t3;

    t1=(unsigned char)data[0];
    t2=(unsigned char)data[1];
    t3=(unsigned char)data[2];
    for(i=3;i<len-3;i++)
    {
/*        s1=(unsigned char)data[i-3];
        s2=(unsigned char)data[i-2];
        s3=(unsigned char)data[i-1];
        data[i] =(unsigned char)((float)t1*(.0216)-(float)t2*(.1299)+
                        (float)t3*(.3247)+(float)data[i]*(.5671)+
                        (float)data[i+1]*(.3247)-(float)data[i+2]*(.1299)+
                        (float)data[i+3]*(.0216));
*/
        t1=s1;
        t2=s2;
        t3=s3;
    }
}

 
#endif 