//
// Compress.c		- Mike Johnson 1998 iready  and (c)1994 Mycal labs www.mycal.net
//           
#include <windows.h>
#include <mmsystem.h>
#include <stdlib.h>	  
#include <math.h>
#include "readwave.h"
#include "compress.h"

        			
int		step_size[] 	= {0x01,0x02,0x04,0x08,0x10,0x20};
int		step_index[6][2]	=  {0x00,0x01,
								0x01,0x03,
								0x02,0x06,
								0x04,0x0c,
								0x08,0x18,
								0x10,0x30};
int		step_size8[] 	= {0x01,0x02,0x04,0x04,0x08,0x0c,0x10,0x20};
int		step_index8[8][2]	=  {0x00,0x01,
								0x01,0x03,
								0x02,0x04,
								0x04,0x06,
								0x04,0x8,
								0x5,0x06,
								0x08,0x18,
								0x10,0x30};

int		step_size31[]	= {0x02,0x04,0x08,0x10,0x20};
int		step_index31[5][4] = {0x00,0x01,0x02,0x03, 
							  0x01,0x03,0x05,0x07,
							  0x02,0x06,0x0a,0x0e,
							  0x04,0x0c,0x14,0x1c,
							  0x05,0x0f,0x19,0x23};																						

//char	rdata[]={0x05,0x32,0x72,0x33,0xf4,0x9f,0xf8,0x00,0x23,0xdc,0x54,0xab,
//					0x74,0x8a,0x23,0xdc,0x54,0xab,0x74,0x8a,0x23,0xdc,0x54,0xab};



int
Compress_ADPCM41_6row(hwndApp,sound,pre,post)
HWND	hwndApp;
SOUND	*sound;
int		pre;
int		post;
{                        
unsigned long			i,j;
int				delta=0;    
int				value,prev,prev1;
int				cp=0;
int				ref_sample=0;
int				row_index=0;
int				step_delta=0;	
int				chunk=0;   
int				sign=0;
unsigned long	index=0;				                 
HANDLE          ucdataHandle    = NULL;
HPSTR           ucdata      	= NULL;    
HANDLE          cdataHandle	    = NULL;
HPSTR           cdata      		= NULL;                                  
HPSTR			tdata			=NULL;
	//
	// Cleanup any perviously created compressed samples
	//
    Cleanup_Compressed_Sound(sound);
	//
	// Allocate New Compressed/Uncompressed Sound Memory 
	//													
	if(sound->data_size==0)
		return 0;     
		
	ucdataHandle = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, sound->data_size);
	if (!ucdataHandle)
    {
        MessageBox(hwndApp, "Out of memory.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    } 																					
    ucdata = GlobalLock(ucdataHandle);
    if (!ucdata)
    {                       						
        MessageBox(hwndApp, "Failed to lock memory for Uncompressed Data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalFree(ucdataHandle);
        return 0;
    }
	cdataHandle = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, sound->data_size/2);
	if (!cdataHandle)
    {
        MessageBox(hwndApp, "Out of memory.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
		GlobalUnlock(ucdataHandle);
    	GlobalFree(ucdataHandle);
        return 0;
    }                					
    cdata = GlobalLock(cdataHandle);
    if (!cdata)
    {    												                   						
        MessageBox(hwndApp, "Failed to lock memory for Compressed Data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalFree(cdataHandle);
		GlobalUnlock(ucdataHandle);
    	GlobalFree(ucdataHandle);
        return 0;
    }
	//
	// We've got memory, so compress
	//			
	cdata[0]=0;	            
	tdata=sound->data;
	prev=ref_sample=0x80;
	for(i=0;i<sound->data_size;i++)
	{                          					
		//
		//  See if we should pre filter Filter
		//
		if(pre)
		{
			if((i>1) && (i<sound->data_size))
			{      					   
				value=((unsigned char)prev)/4 +
					  ((unsigned char)tdata[i])/2
					 +((unsigned char)tdata[i+1])/4;
				prev=tdata[i];
			}
        }  
        else
        	value=tdata[i];
																					    				
		delta=ref_sample-(unsigned char)value;
        if(delta<0)
        	sign=0;
        else
        	sign=1;	
        //
        //
        //
		step_delta=step_size[row_index] - abs(delta);
		if(step_delta<0)
			cp=1;
		else
			cp=0;	
		//
		//
		if(sign)
			ref_sample-=step_index[row_index][cp];
		else
			ref_sample+=step_index[row_index][cp];
		//
		// Adjust Row Index
		//
		if(cp)
			row_index++;
		else
			row_index--;
		//
		// Clip Row Index
		//	
		if(row_index<0)
			row_index=0;
		if(row_index>5)
			row_index=5;
		//
		// Store info in chunk
		//                    
		cdata[index]=(cdata[index]<<2) | (sign<<1) | cp;
		chunk++;
		if(chunk>=4)
		{
			index++;
			chunk=0;
		}				
		//
		// Check Direction
		//				
	}
	sound->cdataHandle=cdataHandle;	
	sound->cdata=cdata;			
	sound->cdata_size=index;

	//
	// Now uncompress
	//	    
	delta=0;
	step_delta=0;                  
	row_index=0;
	prev=prev1=ref_sample=0x80;                  
	index=0;
	for(i=0;i<sound->cdata_size;i++)
	{
		//
		// Process the compressed data chunks in the byte
		//
		for(j=4;j>0;j--)
		{       
			chunk = (cdata[i] >> (2*(j-1))) & 0x03;
			cp=chunk & 0x01;
			if(chunk &0x2)
				ref_sample = ref_sample	- step_index[row_index][cp];
			else
				ref_sample = ref_sample	+ step_index[row_index][cp];
			//
			// Adjust Row Index
			//
			if(cp)
				row_index++;
			else
				row_index--;
			//
			// Clip Row Index
			//	
			if(row_index<0)
				row_index=0;
			if(row_index>5)
				row_index=5;
			//
			// Store ref sample (clip to max values)
			//             
			if(ref_sample<0)
				ucdata[index++]=0;
			else if(ref_sample>255)
				ucdata[index++]=(unsigned char)0xff;
			else		    
				ucdata[index++]=ref_sample;   
			//
			// See if we want the Post Filter
			//
			if(post)
			{          
				if(index>1)
				{        
					prev1=ucdata[index-2];
					ucdata[index-2]=(((unsigned char)prev)/4 + ((unsigned char)ucdata[index-2])/2
						 +((unsigned char)ucdata[index-1])/4);  
					prev=prev1;	 
				}
			}
		}        						
	}                           
	sound->ucdataHandle=ucdataHandle;
	sound->ucdata=ucdata;                 
	if(index>sound->data_size)
	    sound->ucdata_size=sound->data_size;
	else
		sound->ucdata_size=index;      
	
	return 1;
} 

//------------------------------------------------------------------------
//------------------------------------------------------------------------
//
//------------------------------------------------------------------------
//------------------------------------------------------------------------
int
Compress_ADPCM41_8row(hwndApp,sound,pre,post)
HWND	hwndApp;
SOUND	*sound;
int		pre;
int		post;
{ 
static	int		tt;
int				t;
unsigned long			i,j;
int				prev,prev1,value=0;
int				delta=0;    
int				cp=0;
int				ref_sample=0;
int				row_index=0;
int				step_delta=0;	
int				chunk=0;   
int				sign=0; 
int				oldsign=0;
unsigned long			index=0;				                 
HANDLE          ucdataHandle    = NULL;
HPSTR           ucdata      	= NULL;    
HANDLE          cdataHandle	    = NULL;
HPSTR           cdata      		= NULL;                                  
HPSTR			tdata			=NULL;
	//
	// Cleanup any perviously created compressed samples
	//
    Cleanup_Compressed_Sound(sound);
	//
	// Allocate New Compressed/Uncompressed Sound Memory 
	//													
	if(sound->data_size==0)
		return 0;
	ucdataHandle = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, sound->data_size);
	if (!ucdataHandle)
    {
        MessageBox(hwndApp, "Out of memory.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    } 																					
    ucdata = GlobalLock(ucdataHandle);
    if (!ucdata)
    {                       						
        MessageBox(hwndApp, "Failed to lock memory for Uncompressed Data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalFree(ucdataHandle);
        return 0;
    }
	cdataHandle = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, sound->data_size/2);
	if (!cdataHandle)
    {
        MessageBox(hwndApp, "Out of memory.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
		GlobalUnlock(ucdataHandle);
    	GlobalFree(ucdataHandle);
        return 0;
    }                					
    cdata = GlobalLock(cdataHandle);
    if (!cdata)
    {    												                   						
        MessageBox(hwndApp, "Failed to lock memory for Compressed Data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalFree(cdataHandle);
		GlobalUnlock(ucdataHandle);
    	GlobalFree(ucdataHandle);
        return 0;
    }
	//
	// We've got memory, so compress
	//			
	cdata[0]=0;	
	t=0;    
	tt=0;   
	tdata=sound->data; 
	prev=ref_sample=0x80;
	for(i=0;i<sound->data_size;i++)
	{                          					
		//
		//  See if we should pre filter Filter
		//
		if(pre)
		{
			if((i>1) && (i<sound->data_size))
			{      					   
				value=((unsigned char)prev)/4 +
					  ((unsigned char)tdata[i])/2
					 +((unsigned char)tdata[i+1])/4;
				prev=tdata[i];
			}
        }  
        else
        	value=tdata[i];
											    				
		delta=ref_sample-(unsigned char)value;
        
        oldsign=sign;
        if(delta<0)
        	sign=0;
        else
        	sign=1;	 

		if(sign!=oldsign)
		{
			//row_index=0;
		}
        //
        //
        //
		step_delta=step_size8[row_index] - abs(delta);
		if(step_delta<0)
			cp=1;
		else
			cp=0;	

		//
		//
		if(sign)
			ref_sample-=step_index8[row_index][cp];
		else
			ref_sample+=step_index8[row_index][cp];
		
		
		//
		// Adjust Row Index
		//
		if(cp)
			row_index++;
		else
			row_index--;

		//
		// Clip Row Index
		//	
		if(row_index<0)
			row_index=0;
		if(row_index>7)
			row_index=7;
		//
		// Store info in chunk
		//                    
		cdata[index]=(cdata[index]<<2) | (sign<<1) | cp;
		chunk++;
		if(chunk>=4)
		{
			index++;
			chunk=0;
		}				
		//
		// Check Direction
		//				
	}
	sound->cdataHandle=cdataHandle;	
	sound->cdata=cdata;			
	sound->cdata_size=index;

	//
	// Now uncompress
	//	    
	delta=0;
	step_delta=0;                  
	row_index=0;
	ref_sample=0x80;                  
	index=0;
	for(i=0;i<sound->cdata_size;i++)
	{
		//
		// Process the compressed data chunks in the byte
		//
		for(j=4;j>0;j--)
		{       
			chunk = (cdata[i] >> (2*(j-1))) & 0x03;

			cp=chunk & 0x01;  

			oldsign=sign;
			sign=(chunk & 0x2);
		
			if(sign!=oldsign)
			{
			//	row_index=0;
			}
			if(chunk &0x2)
				ref_sample = ref_sample	- step_index8[row_index][cp];
			else
				ref_sample = ref_sample	+ step_index8[row_index][cp];
			
			//
			// Adjust Row Index
			//
			if(cp)
				row_index++;
			else
				row_index--;
			//
			// Clip Row Index
			//	
			if(row_index<0)
				row_index=0;
			if(row_index>7)
				row_index=7;
			//
			// Store ref sample (clip to max values)
			//             
			if(ref_sample<0)
				ucdata[index++]=0;
			else if(ref_sample>255)
				ucdata[index++]=(unsigned char)0xff;
			else		    
				ucdata[index++]=ref_sample;   
			//
			// See if we want the Post Filter
			//
			if(post)
			{          
				if(index>1)
				{        
					prev1=ucdata[index-2];
					ucdata[index-2]=(((unsigned char)prev)/4 + ((unsigned char)ucdata[index-2])/2
						 +((unsigned char)ucdata[index-1])/4);  
					prev=prev1;	 
				}
			}
		}        						
	}                           
	sound->ucdataHandle=ucdataHandle;
	sound->ucdata=ucdata;
	sound->ucdata_size=index;      
	
	return 1;
}


//------------------------------------------------------------------------
//------------------------------------------------------------------------
//
//------------------------------------------------------------------------
//------------------------------------------------------------------------
int    						
Compress_ADPCM41x(hwndApp,sound,pre,post)
HWND	hwndApp;
SOUND	*sound;                       
int		pre;
int		post;
{ 
static	int		tt;
int				value,prev,prev1;
unsigned long	i,j;
int				delta=0;    
int				cp=0;
int				ref_sample=0;
int				row_index=0;
int				step_delta=0;	
int				chunk=0;   
int				sign=0; 
int				oldsign=0;
long			index=0;				                 
HANDLE          ucdataHandle    = NULL;
HPSTR           ucdata      	= NULL;    
HANDLE          cdataHandle	    = NULL;
HPSTR           cdata      		= NULL;                                  
HPSTR			tdata			=NULL;
	//
	// Cleanup any perviously created compressed samples
	//
    Cleanup_Compressed_Sound(sound);
	//
	// Allocate New Compressed/Uncompressed Sound Memory 
	//													
	if(sound->data_size==0)
		return 0;
	ucdataHandle = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, sound->data_size);
	if (!ucdataHandle)
    {
        MessageBox(hwndApp, "Out of memory.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    } 																					
    ucdata = GlobalLock(ucdataHandle);
    if (!ucdata)
    {                       						
        MessageBox(hwndApp, "Failed to lock memory for Uncompressed Data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalFree(ucdataHandle);
        return 0;
    }
	cdataHandle = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, sound->data_size/2);
	if (!cdataHandle)
    {
        MessageBox(hwndApp, "Out of memory.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
		GlobalUnlock(ucdataHandle);
    	GlobalFree(ucdataHandle);
        return 0;
    }                					
    cdata = GlobalLock(cdataHandle);
    if (!cdata)
    {    												                   						
        MessageBox(hwndApp, "Failed to lock memory for Compressed Data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalFree(cdataHandle);
		GlobalUnlock(ucdataHandle);
    	GlobalFree(ucdataHandle);
        return 0;
    }
	//
	// We've got memory, so compress
	//			
	cdata[0]=0;	
	tt=0;   
	tdata=sound->data;
	prev=ref_sample=0x80;
	for(i=0;i<sound->data_size;i++)
	{                          					
		//
		//  See if we should pre filter Filter
		//
		if(pre)
		{
			if((i>1) && (i<sound->data_size))
			{      					   
				value=((unsigned char)prev)/4 +
					  ((unsigned char)tdata[i])/2
					 +((unsigned char)tdata[i+1])/4;
				prev=tdata[i];
			}
        }                  
        else
        	value=tdata[i];

		delta=ref_sample-(unsigned char)value;
        
        oldsign=sign;
        if(delta<0)
        	sign=0;
        else
        	sign=1;	 
         
		if(sign!=oldsign)
		{
				//row_index--;
				//if(row_index<0)
					row_index=0;
		}
        //
        //
        //
		step_delta=step_size[row_index] - abs(delta);


		if(step_delta<0)
			cp=1;
		else
			cp=0;	

		//
		//
		if(sign)
			ref_sample-=step_index[row_index][cp];
		else
			ref_sample+=step_index[row_index][cp];

		//
		// Adjust Row Index
		//
		if(cp)
			row_index++;
		else
			row_index--;

		//
		// Clip Row Index
		//	
		if(row_index<0)
			row_index=0;
		if(row_index>5)
			row_index=5;
		//
		// Store info in chunk
		//                    
		cdata[index]=(cdata[index]<<2) | (sign<<1) | cp;
		chunk++;
		if(chunk>=4)
		{
			index++;
			chunk=0;
		}				
		//
		// Check Direction
		//				
	}
	sound->cdataHandle=cdataHandle;	
	sound->cdata=cdata;			
	sound->cdata_size=index;

	//
	// Now uncompress
	//	    
	delta=0;
	step_delta=0;                  
	row_index=0;
	prev=ref_sample=0x80;                  
	index=0;
	for(i=0;i<sound->cdata_size;i++)
	{
		//
		// Process the compressed data chunks in the byte
		//
		for(j=4;j>0;j--)
		{       
			chunk = (cdata[i] >> (2*(j-1))) & 0x03;

			cp=chunk & 0x01;  

			oldsign=sign;
			sign=(chunk & 0x2);
		
			if(sign!=oldsign)
			{
				//row_index--;
				//if(row_index<0)
					row_index=0;
			}
			if(chunk &0x2)
				ref_sample = ref_sample	- step_index[row_index][cp];
			else
				ref_sample = ref_sample	+ step_index[row_index][cp];

			//
			// Adjust Row Index
			//
			if(cp)
				row_index++;
			else
				row_index--;
			//
			// Clip Row Index
			//	
			if(row_index<0)
				row_index=0;
			if(row_index>5)
				row_index=5;
			//
			// Store ref sample (clip to max values)
			//             
			if(ref_sample<0)
				ucdata[index++]=0;
			else if(ref_sample>255)
				ucdata[index++]=(unsigned char)0xff;
			else		    
				ucdata[index++]=ref_sample;   
			//
			// See if we want the Post Filter
			//
			if(post)
			{          
				if(index>1)
				{        
					prev1=ucdata[index-2];
					ucdata[index-2]=(((unsigned char)prev)/4 + ((unsigned char)ucdata[index-2])/2
						 +((unsigned char)ucdata[index-1])/4);  
					prev=prev1;	 
				}
			}
		}        						
	}                           
	sound->ucdataHandle=ucdataHandle;
	sound->ucdata=ucdata;
	sound->ucdata_size=index;      
	
	return 1;
}

//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
int
Compress_ADPCM31(hwndApp,sound,pre,post)
HWND	hwndApp;
SOUND	*sound;
int		pre;
int		post;
{ 
static	int		tt;
int				t,value;                       
unsigned long	i,j;
int				prev,prev1;
int				delta=0;    
int				cp=0;
int				msb,lsb;
int				ref_sample=0;
int				row_index=0;
int				step_delta=0;	
int				chunk=0;   
int				sign=0; 
int				oldsign=0;
long			index=0;				                 
HANDLE          ucdataHandle    = NULL;
HPSTR           ucdata      	= NULL;    
HANDLE          cdataHandle	    = NULL;
HPSTR           cdata      		= NULL;                                  
HPSTR			tdata			=NULL;
	//
	// Cleanup any perviously created compressed samples
	//
    Cleanup_Compressed_Sound(sound);
	//
	// Allocate New Compressed/Uncompressed Sound Memory 
	//													
	if(sound->data_size==0)
		return 0;
	ucdataHandle = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, sound->data_size);
	if (!ucdataHandle)
    {
        MessageBox(hwndApp, "Out of memory.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    } 																					
    ucdata = GlobalLock(ucdataHandle);
    if (!ucdata)
    {                       						
        MessageBox(hwndApp, "Failed to lock memory for Uncompressed Data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalFree(ucdataHandle);
        return 0;
    }
	cdataHandle = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, sound->data_size/2);
	if (!cdataHandle)
    {
        MessageBox(hwndApp, "Out of memory.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
		GlobalUnlock(ucdataHandle);
    	GlobalFree(ucdataHandle);
        return 0;
    }                					
    cdata = GlobalLock(cdataHandle);
    if (!cdata)
    {    												                   						
        MessageBox(hwndApp, "Failed to lock memory for Compressed Data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalFree(cdataHandle);
		GlobalUnlock(ucdataHandle);
    	GlobalFree(ucdataHandle);
        return 0;
    }
	//
	// We've got memory, so compress
	//			
	cdata[0]=0;	
	t=0;    
	tt=0;   
	tdata=sound->data; 
	prev=ref_sample=0x80;   
	chunk=0;
	for(i=0;i<sound->data_size;i++)
	{                          					
		//
		//  See if we should pre filter Filter
		//
		if(pre)
		{
			if((i>1) && (i<sound->data_size))
			{      					   
				value=((unsigned char)prev)/4 +
					  ((unsigned char)tdata[i])/2
					 +((unsigned char)tdata[i+1])/4;
				prev=tdata[i];
			}
        }
        else
        	value=tdata[i];
		//
		//
		//
		delta=(unsigned char)value-ref_sample;										    				
                   
		oldsign=sign;                   
        if(delta<0)
        	sign=0;
        else
        	sign=1;	 

		delta=abs(delta);
		msb=delta-step_size31[row_index];
		lsb = msb - (step_size31[row_index]/2);
        //
        // Calc MSB code
        //
		if(msb<0)
			msb=0;
		else
			msb=0x2;
		//
		// Calc LSB code
		//	
		if(lsb>0)
			msb|=1;
		//
		if(chunk==2)
			msb=msb&2;
		//
		//
		//              
//	if(oldsign!=sign)
//		row_index=0;
		
		if(sign)
			ref_sample+=step_index31[row_index][msb];
		else
			ref_sample-=step_index31[row_index][msb];

		//
		// Adjust Row Index
		//
		if(msb==0)
			row_index--;
		if(msb==3)
			row_index++;

		//
		// Clip Row Index
		//	
		if(row_index<0)
			row_index=0;
		if(row_index>4)
			row_index=4;
		//
		// Store info in chunk
		//         
		if(chunk==2)
		{           
			cdata[index]=(cdata[index]<<2) | (sign<<1) | (msb>>1);	
			index++;
			chunk=0;
		}
		else
		{			
			cdata[index]=(cdata[index]<<3) | (sign<<2) | msb;
			chunk++;
		}
	}
	sound->cdataHandle=cdataHandle;	
	sound->cdata=cdata;			
	sound->cdata_size=index;

	//
	// Now uncompress
	//	    
	delta=0;
	step_delta=0;                  
	row_index=0;
	ref_sample=0x80;                  
	index=0;
	for(i=0;i<sound->cdata_size;i++)
	{
		//
		// Process the compressed data chunks in the byte
		//
		for(j=3;j>0;j--)
		{       
			if(j!=1)
				chunk = (cdata[i] >> ((3*(j-1))-1)) & 0x07;
			else
			 	chunk = ((cdata[i] & 0x03)<<1)&0x6;
			                     
			                     
			oldsign=sign;
			sign=(chunk & 0x4);
		
			chunk=(chunk & 0x3);

//	if(oldsign!=sign)
//			row_index=0;
		
			if(sign)																
				ref_sample = ref_sample	+ step_index31[row_index][chunk];
			else
				ref_sample = ref_sample	- step_index31[row_index][chunk];

			//
			// Adjust Row Index
			//
			if(chunk==0x3)
				row_index++;
			if(chunk==0x0)
				row_index--;
			//
			// Clip Row Index
			//	
			if(row_index<0)
				row_index=0;
			if(row_index>4)
				row_index=4;
			//
			// Store ref sample (clip to max values)
			//             
			if(ref_sample<0)
				ucdata[index++]=0;
			else if(ref_sample>255)
				ucdata[index++]=(unsigned char)0xff;
			else		    
				ucdata[index++]=ref_sample;   
			//
			// See if we want the Post Filter
			//
			if(post)
			{          
				if(index>1)
				{        
					prev1=ucdata[index-2];
					ucdata[index-2]=(((unsigned char)prev)/4 + ((unsigned char)ucdata[index-2])/2
						 +((unsigned char)ucdata[index-1])/4);  
					prev=prev1;	 
				}
			}
		}        						
	}                           
	sound->ucdataHandle=ucdataHandle;
	sound->ucdata=ucdata;
	sound->ucdata_size=index;      
	
	return 1;
}

//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
int
Compress_ABC2(hwndApp,sound,pre,post)
HWND	hwndApp;
SOUND	*sound;
int		pre;
int		post;
{ 
int				step_size,obit,cross,sign,oldsign;
unsigned char	step;
static	int		tt;
int				t,value,last,overload;                       
unsigned long	i,j,k;
int				prev,prev1;
int				ref_sample=0;
long			counter=0;
long			index=0;				                 
HANDLE          ucdataHandle    = NULL;
HPSTR           ucdata      	= NULL;    
HANDLE          cdataHandle	    = NULL;
HPSTR           cdata      		= NULL;                                  
HPSTR			tdata			=NULL;
	//
	// Cleanup any perviously created compressed samples
	//
    Cleanup_Compressed_Sound(sound);
	//
	// Allocate New Compressed/Uncompressed Sound Memory 
	//													
	if(sound->data_size==0)
		return 0;
	ucdataHandle = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, sound->data_size+1024);
	if (!ucdataHandle)
    {
        MessageBox(hwndApp, "Out of memory.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    } 																					
    ucdata = GlobalLock(ucdataHandle);
    if (!ucdata)
    {                       						
        MessageBox(hwndApp, "Failed to lock memory for Uncompressed Data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalFree(ucdataHandle);
        return 0;
    }
	cdataHandle = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, sound->data_size/2);
	if (!cdataHandle)
    {
        MessageBox(hwndApp, "Out of memory.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
		GlobalUnlock(ucdataHandle);
    	GlobalFree(ucdataHandle);
        return 0;
    }                					
    cdata = GlobalLock(cdataHandle);
    if (!cdata)
    {    												                   						
        MessageBox(hwndApp, "Failed to lock memory for Compressed Data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalFree(cdataHandle);
		GlobalUnlock(ucdataHandle);
    	GlobalFree(ucdataHandle);
        return 0;
    }
	//
	// We've got memory, so compress
	//	

#define BLOCK_SIZE	80

	ref_sample=0;
	tdata=sound->data;	
	index=0;  
	j=0;                             
	last=0;
	overload=0;             
	prev=0x80;
	while(j<sound->data_size)
	{ 
		//
		// Find the average slope
		//     
		step_size=0;
		cross=0;                                    
		prev=(((unsigned char)tdata[0])-128)<<2;
		for(i=1;i<BLOCK_SIZE;i++)
		{
			
			if((i+j) > sound->data_size)
			{
				step_size=step_size + (abs(0x0 - prev));
				prev=0x80;
			}
			else		
			{									
				t=((unsigned char)tdata[i+j]-128)<<2;
				if(t<0)
					sign=0;
				else
					sign=1;	
				if(sign!=oldsign)
					cross++;
				oldsign=sign;						
				step_size=step_size +abs(t - prev);
				prev=t;//(((unsigned char)tdata[i+j])-128)<<2;
			}	
		} 								            
		step_size=step_size/(BLOCK_SIZE);
		step=step_size;
		//
		// Store step size
		//	   
		if(step<4)
			step=0;	
		else
		{
			if(step>0x7f)
				step=0x7f;
		
			if(cross>(BLOCK_SIZE/16))
			{
				step=step | 0x80;				
				cross=1;
			}	
			else
				cross=0;			

    	}
    
		cdata[index++]=step;
	
		step=step & 0x7f;		
		//
		// Compute block if step_size
		//                           
		if(step)                                
		{
			counter=0;    
			obit=0;
			for(i=0;i<BLOCK_SIZE;i++)
			{
				if(cross)   								
					ref_sample = (int)((float)ref_sample * .89);
				else
					ref_sample = (int)((float)ref_sample * .75);
				                        
				if((i+j) > sound->data_size)
					t=(unsigned char)0;
				else
					t=(int)((unsigned char)tdata[i+j])-128;
										                        
				if(t > (ref_sample/4))
			    {               
			    	if(last==0)
			    		overload=0;
			    	//if(cross)
			    	//	overload=0;
			    	
			    	ref_sample=ref_sample+(step+(overload*(step>>2)));
			    	
			    	if(cross)
			    	{
			    			if(obit==0)
			    			{
						    	cdata[index+(counter>>3)] = cdata[index+(counter>>3)] 
			    								| 1 << (counter %8); 

								obit=1;
								counter++;								
							}
							else
							{             
								obit=0;
							}
				    }
				    else
				    {
						    cdata[index+(counter>>3)] = cdata[index+(counter>>3)] 
			    								| 1 << (counter %8); 

				    		counter++;
				    }
					overload++;
			    	last=1;							
			    }  
			    else
			    {          
			    	if(last==1)
			    		overload=0;                         
			    	//if(cross)
			    	//	overload=0;
			    	
			    	ref_sample=ref_sample-(step+(overload*(step>>2)));
			    	
			    	if(cross)
			    	{
			    			if(obit==0)
			    			{
			    				cdata[index+(counter>>3)] = cdata[index+(counter>>3)]
			    								& ~(1 << (counter % 8));
								obit=1;
								counter++;								
							}
							else
							{             
								obit=0;
							}
				    }
				    else
				    {
			    			cdata[index+(counter>>3)] = cdata[index+(counter>>3)]
			    								& ~(1 << (counter % 8));
				    
				    		counter++;
				    }
					overload++;
			    	last=0;
			    }
			}             
			if(cross==0)
				index=index+BLOCK_SIZE/8;
			else
				index=index+(BLOCK_SIZE/16);
		}   
		else
			ref_sample=0;
			               
		j=j+BLOCK_SIZE;
	}//end while	
	//
	// Store compressed data
	//
	sound->cdataHandle=cdataHandle;	
	sound->cdata=cdata;			
	sound->cdata_size=index;

	//
	// Decompress
	//	
	ref_sample=0x0;
	index=0;
	j=0;                       
	last=0;
	overload=0;
	while(j<sound->cdata_size)
	{
		if(cdata[j]==0)
		{
			//
			// Replicate Silence at current ref_sample
			// 
			for(i=0;i<BLOCK_SIZE;i++)
			{
				ucdata[index++]=(unsigned char)128;//ref_sample;		
							
				if(post)
				{          
					if(index>1)
					{        
						prev1=ucdata[index-2];
						ucdata[index-2]=(((unsigned char)prev)/4 + ((unsigned char)ucdata[index-2])/2
							 +((unsigned char)ucdata[index-1])/4);  
						prev=prev1;	 
					}
				}

			}
			ref_sample=0;
			j++;
		}		                           
		else
		{              
			step=cdata[j++];
			cross=step&0x80;
			step=step&0x7f;         
			obit=0;					
			for(i=1,k=0;i<BLOCK_SIZE+1;i++)
			{                  
				if(cross)
				{
					if(obit==0)
						k++;
						
					ref_sample = (int)((float)ref_sample * .89);
				}
				else
				{           
					k=i;
					ref_sample = (int)((float)ref_sample * .75);
	            }
			if((cross==0) || (obit==0))
			{			      						           								
				if(cdata[j+((k-1)>>3)] & (1 << ((k-1) % 8)))
				{
					if(last==0)
						overload=0;
					//if(cross)
					//	overload=0;
					
					ref_sample=ref_sample + (step+(overload*(step>>2)));
					
					overload++;
					last=1;
				}                                     
				else
				{                  
					if(last==1)
						overload=0;
					//if(cross)
					//	overload=0;
					ref_sample=ref_sample - (step+(overload*(step>>2)));				
					overload++;
					last=0;
				} 
				obit=1;
			}          
			else
				obit=0;
				
				//
				// clip
				//
				t=(ref_sample>>2)+128;
        		if(t>255)
        			t=255;
        		if(t<0)
        			t=0;	
        		ucdata[index++]=(unsigned char)t;
				//
				// See if we want the Post Filter
				//
				if(post)
				{          
					if(index>1)
					{        
						prev1=ucdata[index-2];
						ucdata[index-2]=(((unsigned char)prev)/4 + ((unsigned char)ucdata[index-2])/2
							 +((unsigned char)ucdata[index-1])/4);  
						prev=prev1;	 
					}
				}
			}
			if(!cross)
				j=j+(BLOCK_SIZE/8);
			else
				j=j+(BLOCK_SIZE/16);
			
		}
	}
	sound->ucdataHandle=ucdataHandle;
	sound->ucdata=ucdata;
	sound->ucdata_size=index;      
	
	return 1;
}


//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
int
Compress_ABC(hwndApp,sound,pre,post)
HWND	hwndApp;
SOUND	*sound;
int		pre;
int		post;
{ 
int				step_size,cross,sign,oldsign;
unsigned char	step;
static	int		tt;
int				t,value,last,overload;                       
unsigned long	i,j;
int				prev,prev1,preva;
int				ref_sample=0;
long			counter=0;
long			index=0;				                 
HANDLE          ucdataHandle    = NULL;
HPSTR           ucdata      	= NULL;    
HANDLE          cdataHandle	    = NULL;
HPSTR           cdata      		= NULL;                                  
HPSTR			tdata			=NULL;
	//
	// Cleanup any perviously created compressed samples
	//
    Cleanup_Compressed_Sound(sound);
	//
	// Allocate New Compressed/Uncompressed Sound Memory 
	//													
	if(sound->data_size==0)
		return 0;
	ucdataHandle = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, sound->data_size+1024);
	if (!ucdataHandle)
    {
        MessageBox(hwndApp, "Out of memory.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    } 																					
    ucdata = GlobalLock(ucdataHandle);
    if (!ucdata)
    {                       						
        MessageBox(hwndApp, "Failed to lock memory for Uncompressed Data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalFree(ucdataHandle);
        return 0;
    }
	cdataHandle = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, sound->data_size/2);
	if (!cdataHandle)
    {
        MessageBox(hwndApp, "Out of memory.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
		GlobalUnlock(ucdataHandle);
    	GlobalFree(ucdataHandle);
        return 0;
    }                					
    cdata = GlobalLock(cdataHandle);
    if (!cdata)
    {    												                   						
        MessageBox(hwndApp, "Failed to lock memory for Compressed Data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalFree(cdataHandle);
		GlobalUnlock(ucdataHandle);
    	GlobalFree(ucdataHandle);
        return 0;
    }
	//
	// We've got memory, so compress
	//	

#define BLOCK_SIZE	80

	ref_sample=0;
	tdata=sound->data;	
	index=0;  
	j=0;                             
	last=0;
	overload=0;             
	prev=0x0;       
	preva=0;
	while(j<sound->data_size)
	{ 
		//
		// Find the average slope
		//     
		step_size=0;
		cross=0;                                    
		prev=(((unsigned char)tdata[0])-128)<<2;
		for(i=1;i<BLOCK_SIZE;i++)
		{
			
			if((i+j) > sound->data_size)
			{
				step_size=step_size + (abs(0x0 - prev));
				prev=0x80;
			}
			else		
			{									
		//
		//  See if we should pre filter Filter
		//
		if(pre)
		{
			if((j>1) && (j<sound->data_size))
			{      					   
				value=((unsigned char)preva)/4 +
					  ((unsigned char)tdata[j+i])/2
					 +((unsigned char)tdata[i+j+1])/4;
				preva=(unsigned char)tdata[j+i];
			}
        }
        else
        	value=(unsigned char)tdata[j+i];

				//t=((unsigned char)tdata[i+j]-128)<<2;
				t=(value-128)<<2;
				if(t<0)
					sign=0;
				else
					sign=1;	
				if(sign!=oldsign)
					cross++;
				oldsign=sign;						
				step_size=step_size +abs(t - prev);
				prev=t;//(((unsigned char)tdata[i+j])-128)<<2;
			}	
		} 								            
		step_size=step_size/(BLOCK_SIZE);
		step=step_size;
		//
		// Store step size
		//	   
		if(step<4)
			step=0;	
		else
		{
			if(step>0x7f)
				step=0x7f;
		
			if(cross>(BLOCK_SIZE/4))
			{
				step=step | 0x80;				
				cross=1;
			}	
			else
				cross=0;			

    	}
    
		cdata[index++]=step;
	
		step=step & 0x7f;		
		//
		// Compute block if step_size
		//                           
		if(step)                                
		{
			counter=0;
			for(i=0;i<BLOCK_SIZE;i++)
			{
				if(cross) 																  								
					ref_sample = (int)((float)ref_sample * .25);
				else
					ref_sample = (int)((float)ref_sample * .75);
				//ref_sample = (int)((float)ref_sample * .89);
				                        
				if((i+j) > sound->data_size)
					t=(unsigned char)0;
				else
					t=(int)((unsigned char)tdata[i+j])-128;
										                        
				if(t > (ref_sample>>2))
			    {               
			    	if(last==0)
			    		overload=0;
			    	if(cross)
			    		overload=0;
			    																		                   						
			    	ref_sample=ref_sample+(step+(overload*(step>>2)));
			    	cdata[index+(counter>>3)] = cdata[index+(counter>>3)] 
			    								| 1 << (counter %8); 
			    	overload++;
			    	last=1;							
			    }  
			    else
			    {          
			    	if(last==1)
			    		overload=0;                         
			    	if(cross)
			    		overload=0;
			    	ref_sample=ref_sample-(step+(overload*(step>>2)));
			    	cdata[index+(counter>>3)] = cdata[index+(counter>>3)]
			    								& ~(1 << (counter % 8));
					overload++;
			    	last=0;
			    }
				counter++;
			}             
			index=index+BLOCK_SIZE/8;
		}   
		else
			ref_sample=0;
			               
		j=j+BLOCK_SIZE;
	}//end while	
	//
	// Store compressed data
	//
	sound->cdataHandle=cdataHandle;	
	sound->cdata=cdata;			
	sound->cdata_size=index;

	//
	// Decompress
	//	
	ref_sample=0x0;
	index=0;
	j=0;                       
	last=0;
	overload=0;
	while(j<sound->cdata_size)
	{
		if(cdata[j]==0)
		{
			//
			// Replicate Silence at current ref_sample
			//                                        
			for(i=0;i<BLOCK_SIZE;i++)
			{
				ucdata[index++]=128;//ref_sample;		
							
				if(post)
				{          
					if(index>1)
					{        
						prev1=ucdata[index-2];
						ucdata[index-2]=(((unsigned char)prev)/4 + ((unsigned char)ucdata[index-2])/2
							 +((unsigned char)ucdata[index-1])/4);  
						prev=prev1;	 
					}
				}

			}
			ref_sample=0;
			j++;
		}		                           
		else
		{              
			step=cdata[j++];
			cross=step&0x80;
			step=step&0x7f;
			for(i=1;i<BLOCK_SIZE+1;i++)
			{                  
				if(cross)
					ref_sample = (int)((float)ref_sample * .25);
				else
					ref_sample = (int)((float)ref_sample * .75);
				                 								
				if(cdata[j+((i-1)>>3)] & (1 << ((i-1) % 8)))
				{
					if(last==0)
						overload=0;
					if(cross)
						overload=0;
					ref_sample=ref_sample + (step+(overload*(step>>2)));
					overload++;
					last=1;
				}                                     
				else
				{                  
					if(last==1)
						overload=0;
					if(cross)
						overload=0;
					ref_sample=ref_sample - (step+(overload*(step>>2)));				
					overload++;
					last=0;
				} 
				//
				// clip
				//
				t=(ref_sample>>2)+128;
        		if(t>255)
        			t=255;
        		if(t<0)
        			t=0;	
        		ucdata[index++]=(unsigned char)t;
				//
				// See if we want the Post Filter
				//
				if(post)
				{          
					if(index>1)
					{        
						prev1=ucdata[index-2];
						ucdata[index-2]=(((unsigned char)prev)/4 + ((unsigned char)ucdata[index-2])/2
							 +((unsigned char)ucdata[index-1])/4);  
						prev=prev1;	 
					}
				}
			}
			j=j+(BLOCK_SIZE/8);
		}
	}
	sound->ucdataHandle=ucdataHandle;
	sound->ucdata=ucdata;
	sound->ucdata_size=index;      
	
	return 1;
}

//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
//------------------------------------------------------------------------
int
Compress_ABC3(hwndApp,sound,pre,post)
HWND	hwndApp;
SOUND	*sound;
int		pre;
int		post;
{ 
int				step_size,cross,sign,oldsign;
unsigned char	step;
static	int		tt;
int				t,value,last,overload;                       
unsigned long	i,j;
int				prev,prev1,preva;
int				ref_sample=0;
long			counter=0;
long			index=0;				                 
HANDLE          ucdataHandle    = NULL;
HPSTR           ucdata      	= NULL;    
HANDLE          cdataHandle	    = NULL;
HPSTR           cdata      		= NULL;                                  
HPSTR			tdata			=NULL;
	//
	// Cleanup any perviously created compressed samples
	//
    Cleanup_Compressed_Sound(sound);
	//
	// Allocate New Compressed/Uncompressed Sound Memory 
	//													
	if(sound->data_size==0)
		return 0;
	ucdataHandle = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, sound->data_size+1024);
	if (!ucdataHandle)
    {
        MessageBox(hwndApp, "Out of memory.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        return 0;
    } 																					
    ucdata = GlobalLock(ucdataHandle);
    if (!ucdata)
    {                       						
        MessageBox(hwndApp, "Failed to lock memory for Uncompressed Data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalFree(ucdataHandle);
        return 0;
    }
	cdataHandle = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, sound->data_size/2);
	if (!cdataHandle)
    {
        MessageBox(hwndApp, "Out of memory.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
		GlobalUnlock(ucdataHandle);
    	GlobalFree(ucdataHandle);
        return 0;
    }                					
    cdata = GlobalLock(cdataHandle);
    if (!cdata)
    {    												                   						
        MessageBox(hwndApp, "Failed to lock memory for Compressed Data.",
                   NULL, MB_OK | MB_ICONEXCLAMATION);
        GlobalFree(cdataHandle);
		GlobalUnlock(ucdataHandle);
    	GlobalFree(ucdataHandle);
        return 0;
    }
	//
	// We've got memory, so compress
	//	

#define BLOCK_SIZE	80

	ref_sample=0;
	tdata=sound->data;	
	index=0;  
	j=0;                             
	last=0;
	overload=0;             
	prev=0x0;       
	preva=0;
	while(j<sound->data_size)
	{ 
		//
		// Find the average slope
		//     
		step_size=0;
		cross=0;                                    
		prev=(((unsigned char)tdata[0])-128)<<2;
		for(i=1;i<BLOCK_SIZE;i++)
		{
			
			if((i+j) > sound->data_size)
			{
				step_size=step_size + (abs(0x0 - prev));
				prev=0x80;
			}
			else		
			{									
		//
		//  See if we should pre filter Filter
		//
		if(pre)
		{
			if((j>1) && (j<sound->data_size))
			{      					   
				value=((unsigned char)preva)/4 +
					  ((unsigned char)tdata[j+i])/2
					 +((unsigned char)tdata[i+j+1])/4;
				preva=(unsigned char)tdata[j+i];
			}
        }
        else
        	value=(unsigned char)tdata[j+i];

				//t=((unsigned char)tdata[i+j]-128)<<2;
				t=(value-128)<<2;
				if(t<0)
					sign=0;
				else
					sign=1;	
				if(sign!=oldsign)
					cross++;
				oldsign=sign;						
				step_size=step_size +abs(t - prev);
				prev=t;//(((unsigned char)tdata[i+j])-128)<<2;
			}	
		} 								            
		step_size=step_size/(BLOCK_SIZE);
		step=step_size;
		//
		// Store step size
		//	   
		if(step<4)
			step=0;	
		else
		{
			if(step>0x7f)
				step=0x7f;
		
			if(cross>(BLOCK_SIZE/4))
			{
				step=step | 0x80;				
				cross=1;
			}	
			else
				cross=0;			

    	}
    
		cdata[index++]=step;
	
		step=step & 0x7f;		
		//
		// Compute block if step_size
		//                           
		if(step)                                
		{
			counter=0;
			for(i=0;i<BLOCK_SIZE;i++)
			{
				if(cross) 																  								
					ref_sample = (int)((float)ref_sample * .25);
				else
					ref_sample = (int)((float)ref_sample * .75);
				//ref_sample = (int)((float)ref_sample * .89);
				                        
				if((i+j) > sound->data_size)
					t=(unsigned char)0;
				else
					t=(int)((unsigned char)tdata[i+j])-128;
										                        
				if(t > (ref_sample>>2))
			    {               
			    	if(last==0)
			    		overload=0;
			    	if(cross)
			    		overload=0;
			    																		                   						
			    	ref_sample=ref_sample+(step+(overload*(step>>2)));
			    	cdata[index+(counter>>3)] = cdata[index+(counter>>3)] 
			    								| 1 << (counter %8); 
			    	overload++;
			    	last=1;							
			    }  
			    else
			    {          
			    	if(last==1)
			    		overload=0;                         
			    	if(cross)
			    		overload=0;
			    	ref_sample=ref_sample-(step+(overload*(step>>2)));
			    	cdata[index+(counter>>3)] = cdata[index+(counter>>3)]
			    								& ~(1 << (counter % 8));
					overload++;
			    	last=0;
			    }
				counter++;
			}             
			index=index+BLOCK_SIZE/8;
		}   
		else
			ref_sample=0;
			               
		j=j+BLOCK_SIZE;
	}//end while	
	//
	// Store compressed data
	//
	sound->cdataHandle=cdataHandle;	
	sound->cdata=cdata;			
	sound->cdata_size=index;

	//
	// Decompress
	//	
	ref_sample=0x0;
	index=0;
	j=0;                       
	last=0;
	overload=0;
	while(j<sound->cdata_size)
	{
		if(cdata[j]==0)
		{
			//
			// Replicate Silence at current ref_sample
			//                                        
			for(i=0;i<BLOCK_SIZE;i++)
			{
				ucdata[index++]=128;//ref_sample;		
							
				if(post)
				{          
					if(index>1)
					{        
						prev1=ucdata[index-2];
						ucdata[index-2]=(((unsigned char)prev)/4 + ((unsigned char)ucdata[index-2])/2
							 +((unsigned char)ucdata[index-1])/4);  
						prev=prev1;	 
					}
				}

			}
			ref_sample=0;
			j++;
		}		                           
		else
		{              
			step=cdata[j++];
			cross=step&0x80;
			step=step&0x7f;
			for(i=1;i<BLOCK_SIZE+1;i++)
			{                  
				if(cross)
					ref_sample = (int)((float)ref_sample * .25);
				else
					ref_sample = (int)((float)ref_sample * .75);
				                 								
				if(cdata[j+((i-1)>>3)] & (1 << ((i-1) % 8)))
				{
					if(last==0)
						overload=0;
					if(cross)
						overload=0;
					ref_sample=ref_sample + (step+(overload*(step>>2)));
					overload++;
					last=1;
				}                                     
				else
				{                  
					if(last==1)
						overload=0;
					if(cross)
						overload=0;
					ref_sample=ref_sample - (step+(overload*(step>>2)));				
					overload++;
					last=0;
				} 
				//
				// clip
				//
				t=(ref_sample>>2)+128;
        		if(t>255)
        			t=255;
        		if(t<0)
        			t=0;	
        		ucdata[index++]=(unsigned char)t;
				//
				// See if we want the Post Filter
				//
				if(post)
				{          
					if(index>1)
					{        
						prev1=ucdata[index-2];
						ucdata[index-2]=(((unsigned char)prev)/4 + ((unsigned char)ucdata[index-2])/2
							 +((unsigned char)ucdata[index-1])/4);  
						prev=prev1;	 
					}
				}
			}
			j=j+(BLOCK_SIZE/8);
		}
	}
	sound->ucdataHandle=ucdataHandle;
	sound->ucdata=ucdata;
	sound->ucdata_size=index;      
	
	return 1;
}

/////////////////////////
/////////////////////////
/////////////////////////
/////////////////////////

double
snr(buff1,buff2,size)
HPSTR      	buff1;
HPSTR		buff2;
long		size;
{
double  sigma_x, sigma_e,snr;
long    i;
double  x,y;


    sigma_x = sigma_e = 0.0;
    for(i=0;i<size;i++)
    {
        x = (double)buff1[i]/127;
        y = (double)buff2[i]/127;
        sigma_x = sigma_x + x*x;
        sigma_e = sigma_e + (x-y)*(x-y);
    }

    sigma_x = sigma_x / (double) size;
    sigma_e = sigma_e / (double) size;

    if(sigma_e >0.0)
    {
           snr = 10.0 * log10(sigma_x/sigma_e);
           return snr;
    }
    else
		return 0;
}

