
/*																www.mycal.com			
 *---------------------------------------------------------------------------
 * timeer.c - Time/timer related fucntions. (intel port versions)			-
 *																			-
 *---------------------------------------------------------------------------
 * Version                                                                  -
 *		0.1 Original Version June 3, 2000									-        
 *
 *---------------------------------------------------------------------------    
 *                                                             				-
 * Copyright (C) 2000, Mycal Labs www.mycal.com								-
 *                                                                         	-
 *---------------------------------------------------------------------------
*/
/*					*/ 
/* include files 	*/
/*	
*/
#include "mTypes.h"
#include "judge.h"
#include <stdlib.h>


//
// Timer start for timer, if we need more we can index and allocate.
//
static	U16		time_start;

//
// AVR timer stuff
//
//#define TICKS_PER_SECOND    70
/* TIMER global variables */
volatile U8	 TIMER_Counter;
volatile U16 TIMER_Tick;
volatile U8  TIMER_Second;
//volatile U8	 TIMER_wdt;

/* AVR Timer 0 overflow Signal */
SIGNAL(SIG_OVERFLOW0)
{   
	/* incerment timer */
	TIMER_Counter++;
	TIMER_Tick++;

	/* seconds need to be updated? */
	if(TIMER_Counter>TICKS_PER_SECOND)
	{
		TIMER_Second++;
		TIMER_Counter=0;
	}
	
	/* Reset Timer */
	TCNT0=100;
	//outp((U8)(190/*-TICKS_PER_SECOND*/)/*TIMER_SELECT*/,TCNT0);
	//outp((U8)TIMER_SELECT,TCNT0);
}

/*
void
timer_set(void)
{
	//printf("set timer\n");
	time_start=TIMER_Get_Second();
	if(0==time_start)
		time_start++;
}

U8
timer_timeout(U16 timeout_val)
{
	if(0==time_start)
	{
		//DEBUG1("timerturned off\n");
		return 1;
	}
	if(timeout_val < (TIMER_Get_Second()-time_start))
	{
		return 1;
	}
	else
	{
		//printf("notimeout %d  --  %d \n",timeout_val, TIMER_Get_Second()-time_start);
		return 0;
	}
}

U8
timer_expire(void)
{
	///DEBUG1("turn off\n");
	time_start=0;
	return(0);
}
*/

//#define TICKS_PER_SECOND    100
//U16 TIMER_Counter;
//U8  TIMER_Tick;
//U8  TIMER_Second;

//
// This function initilizes timer 0 on the Mega128/64 (and possibly other avr chips)
//
//
void 
TIMER_Init(void)
{
    /* enable TCNT0 overflow */
    TIMSK0	=(1<<TOIE0);
	//outp((1<<TOIE0),TIMSK);

    /* count Normal mode */
    TCCR0A= 0;
	TCCR0B= 3;
	//outp(0x07,TCCR0A);

    /* reset TCNT0 */
    TCNT0=(255-TICKS_PER_SECOND);
	//outp((U8)(255-TICKS_PER_SECOND)/*TIMER_SELECT*/,TCNT0);
}


//void
//TIMER_WDT(U8 Timeout)
//{
//	TIMER_wdt=Timeout;
//}

void
TIMER_Clear()
{
	TIMER_Counter=TIMER_Tick=TIMER_Second=0;
	return;
}

U16
TIMER_Get_Tick()
{
	return(TIMER_Tick);
}

U16
TIMER_Get_Second()
{
	return(TIMER_Second);
} 


// How long does this wait?
void
TIMER_Wait_Tick(U16 wait_ticks)
{     
U16	tick_start;

	tick_start=TIMER_Get_Tick(); 
    while(1)	
    {   
		//poll_serial();
	   	if(abs(TIMER_Get_Tick()-tick_start) > wait_ticks )	
			break;
	}
}      


void
delay_us(U16 us)
{
	U16 i,j;

	for(i=1;i<us;i++)
		for(j=1;j<2;j++);
}
