#ifndef __ECONFIG_H__
#define __ECONFIG_H__
/*! \file econfig.c \brief uNetE Project Config file. */
//---------------------------------------------------------------------------
// econfig.h - ethernet config header file 									-
//---------------------------------------------------------------------------
// This file contains all the includes used for the project.  It also		- 
//	includes the default equate values for the project.						-
//																			-
//	Great care should be taken to properly configure these values.			-
//																			-
//---------------------------------------------------------------------------
// Version                                                                  -
//		0.1 Original Version July 16, 2002									-
//																			-
// (c)2001 Mycal Labs, All Rights Reserved									-
//---------------------------------------------------------------------------

// Includes for project, first must by the type declares 
#include "mTypes.h"
//
// Add includes for the project here
//
#include "console.h"
#include "time.h"
#include "ports.h"


#define	CRLF	"\r\n"

// Version Number here
#define EM_VERSION				"0.1"


#if defined(__AVR_ATmega8__) || defined(__AVR_ATmega48__) ||\
      defined(__AVR_ATmega88__) || defined(__AVR_ATmega168__)
#  define PWMDDR     DDRB
#  define PWMOUT     PB1

#else
#  error "Unsupported MCU type"
#endif


// Let the compiler determine which AVR chip:
#if defined(__AVR_ATmega48__) || defined(__AVR_ATmega88__) ||\
    defined(__AVR_ATmega168__)
/* map ATmega8/16 names to ATmegaX8 names */
#  define USART_RXC_vect USART_RX_vect
#  define UDR     UDR0
#  define UCSRA   UCSR0A
#  define UCSRB   UCSR0B
#  define FE      FE0
#  define TXEN    TXEN0
#  define RXEN    RXEN0
#  define RXCIE   RXCIE0
#  define TXCIE   TXCIE0
#  define UDRE    UDRE0
#  define U2X     U2X0
#  define UBRRL   UBRR0L

#  define TIMSK   TIMSK1
#  define MCUCSR  MCUSR
#endif



//
// Clocks and baud rate config
//
#define CPU_CLOCK 					7372800     /* 7.3728Mhz -or- 7372800 */
#define	CONSOLE_BAUD_RATE			19200 		/* terminal baud rate 9600bps if no autobaud*/
#define	CPU_CLOCK_DIV100			CPU_CLOCK/100
#define CONSOLE_BAUD_RATE_DIV100	CONSOLE_BAUD_RATE/100
#define CONSOLE_BAUD_STATIC		(CPU_CLOCK_DIV100/(CONSOLE_BAUD_RATE_DIV100*16)-1)


#define F_CPU	CPU_CLOCK

//
// Platform specific stuff
//

#ifdef __AVR__

#ifdef MEGA128						
//#include <iom128.h>
#endif
#ifdef MEGA64						
//#include <iom64.h>
#endif

#include <inttypes.h>
#include <avr/io.h>
#include <avr/interrupt.h>
//#include <signal.h>
//#include <avr/signal.h>
#include <avr/pgmspace.h>
#include <avr/eeprom.h>

#define FLASHMEM __attribute__ ((progmem))

//#define printf				CONSOLE_puts


#endif


#endif 

