/*																www.mycal.net
 *---------------------------------------------------------------------------
 * judge.c - Main file for the finish first pinewood judge project			-
 *---------------------------------------------------------------------------
 * Version                                                                  -                                            
 *		0.1 Original Version Jul 21, 2006    								-        
 *
 *---------------------------------------------------------------------------    
 *                                                             				_
 * Copyright (C) 2006, Mycal Labs, All Rights Reserved.						_
 *															               	_
 *---------------------------------------------------------------------------
*/
//
// Include file for the project
//
#include "judge.h"
#include <ctype.h>
#include <stdint.h>
#include <stdio.h>
#include <avr/io.h>
#include <avr/pgmspace.h>
#include <util/delay.h>
#include "lcd.h"

//
// Strings are stored in FLASH memeory on AVR devices
//
    

#define NUM_LANES	3


#define OL1			(1<<PORT7)
#define OL2			(1<<PORT0)
#define OL3			(1<<PORT1)
#define eRST		(1<<PORT5)
#define GO			(1<<PORT6)


// Global Variables
U16			Current_Time;
U16			Time_Lane_1;
U16			Time_Lane_2;
U16			Time_Lane_3;
//
// Race order	
U8 l1,l2,l3;

//FILE uart_str = FDEV_SETUP_STREAM(putch, NULL, _FDEV_SETUP_WRITE);
//FILE lcd_str = FDEV_SETUP_STREAM(lcd_putchar, NULL, _FDEV_SETUP_WRITE);

void
setup_hw(void)
{
	DDRB=PORTBDIR;
	DDRC=PORTCDIR;
	DDRD=PORTDDIR;

	// weak pullups on inputs
	PORTB=~PORTBDIR;
	PORTC=~PORTCDIR;
	PORTD=~PORTDDIR;
}

void
setup_pwm(void)
{
	
	TCNT1L = 0;
    TCNT1H = 0;
   
	// in CTC mode we can calculate the output freq by oFreq= fclk / (      )
	OCR1AH = 0x0;
	OCR1AL = 0x63;						// 0x63 with no prescale

	// Set toggle OC1B on compair match
	TCCR1A = (1<<COM1B0);

	// Set CTC on OCR1 compair, no prescale
	TCCR1B = (1<<WGM12) | (1<<CS10);
   
	// set interrupt on overflow so we can fine tune timer
	TIMSK1  = (1<<TOIE1);   

}

/*
SIGNAL(SIG_OVERFLOW1)
{ 
	U8 i=1;

	while(i++);
	//OCR1AH = 0x0;
	//OCR1AL = 0xff;
}
*/
extern	char			*_2d( unsigned short val, char *cp, unsigned short dec_digits, unsigned char pad );
/* nibble 2 heX ascii */
#define n2X(ind) ( ((0x000F&(ind))<10)          \
                   ?('0'+(0x000F&(ind)))        \
                   :('A'+((0x000F&(ind))-10)) )
/* short to decimal ascii */
#define s2d( val, cp ) (_2d((val),(cp),(10000),(0)))
#define n2d(ind) (n2X(ind));
/* to decimal ascii */
char 
*_2d( unsigned short val, char *cp, unsigned short dec_digits, unsigned char pad ) 
{	
	unsigned theDigit;
	unsigned short dv;
    unsigned char fill = 0;   
    
	if( (0 == val) && (0 == pad) ) 
    {
		*cp++ = '0';
	}
	else 
    {
		for( dv = dec_digits; dv; dv /= 10 ) 
        {
			theDigit = val / dv;
			if( theDigit || fill ) 
            {
				*cp++ = n2d( theDigit );	/* ascii */
				val -= theDigit * dv;
                fill = 1;
			}
            else 
            {
                if( pad ) *cp++ = '0';
            }
		}
	}
	*cp = '\0';
	return cp;
}


// Figure out the race order, handles ties
race_order()
{

	l1=l2=l3=1;

	if(Time_Lane_1!=Time_Lane_2)
		if(Time_Lane_1<Time_Lane_2)
			l2++;
		else
			l1++;

	if(Time_Lane_1!=Time_Lane_3)
		if(Time_Lane_1<Time_Lane_3)
			l3++;
		else 
			l1++;

	if(Time_Lane_2!=Time_Lane_3)
		if(Time_Lane_2<Time_Lane_3)
			l3++;
		else
			l2++;
}

print_console_time(U16 time,U8 flag)
{
	char tbuf[5];
		s2d(time/1000,tbuf);
		CONSOLE_puts(tbuf);
		CONSOLE_puts(".");

		s2d(time%1000,tbuf);
		CONSOLE_puts(tbuf);

		CONSOLE_puts("  ");

		if(1==flag)
			CONSOLE_puts("1st");
		if(2==flag)
			CONSOLE_puts("2nd");
		if(3==flag)
			CONSOLE_puts("3rd");

		CONSOLE_puts(CRLF);
}

void
print_results(void)
{
	CONSOLE_puts("RR"CRLF);
	print_console_time(Time_Lane_1,l1);
	print_console_time(Time_Lane_2,l2);
	print_console_time(Time_Lane_3,l3);
}

print_time(U16 time,U8 flag)
{
	char tbuf[5];
		s2d(time/1000,tbuf);
		LCD_puts("     ");
		LCD_puts(tbuf);
		LCD_puts(".");

		s2d(time%1000,tbuf);
		LCD_puts(tbuf);

		LCD_puts("\r ");

		if(1==flag)
			LCD_puts("1st");
		if(2==flag)
			LCD_puts("2nd");
		if(3==flag)
			LCD_puts("3rd");

		LCD_puts("\n");
		//fprintf(stderr,"  %2u.%03u\n", time/1000, time%1000);
}


int
Update_Time(U16 Current_Time,U8 flag)
{
//	return 0;

	if(0==Time_Lane_1)
	{
		// Display current Time on Lane 1 LCD
		lcd(1);
		print_time(Current_Time,0);
		//fprintf(stderr,"  %2u.%03u\n", Current_Time/1000, Current_Time%1000);
	}
	else
	{
		// Display Time_Lane_1 on Lane 1 LCD
		lcd(1);
		if(flag)
			print_time(Time_Lane_1,l1);
		else
			print_time(Time_Lane_1,0);
		//fprintf(stderr,"  %2u.%03u\n", Time_Lane_1/1000, Time_Lane_1%1000);
	}
//	return 0;
	if(0==Time_Lane_2)
	{
		// Display current Time on Lane 2 LCD
		lcd(2);
		print_time(Current_Time,0);
		//fprintf(stderr,"  %2u.%03u\n", Current_Time/1000, Current_Time%1000);
	}
	else
	{
		// Display Time_Lane_2 on Lane 2 LCD
		lcd(2);
		if(flag)
			print_time(Time_Lane_2,l2);
		else
			print_time(Time_Lane_2,0);
		//fprintf(stderr,"  %2u.%03u\n", Time_Lane_2/1000, Time_Lane_2%1000);
	}
	//return 0;
	if(0==Time_Lane_3)
	{
		// Display current Time on Lane 3 LCD
		lcd(3);
		print_time(Current_Time,0);
		//fprintf(stderr,"  %2u.%03u\n", Current_Time/1000, Current_Time%1000);
	}
	else
	{
		// Display Time_Lane_1 on Lane 3 LCD
		lcd(3);
		if(flag)
			print_time(Time_Lane_3,l3);
		else
			print_time(Time_Lane_3,0);
		//fprintf(stderr,"  %2u.%03u\n", Time_Lane_1/1000, Time_Lane_3%1000);
	}
	//return 0;
}


ready(void)
{
		LCD_puts("     Ready\n");
}

void
notready(void)
{
		LCD_puts("    Not Ready\n");
}


// return 0 if sensors are ready
int check_sensors(U8 s)
{
U8			current;
static U8	last;

	
	// Read the current status
	current=(PIND & OL1) | (PINB & OL2) | (PINB & OL3);
	// only display on change, check
	if((current!=last) || (s))
	{
		last=current;
		// Check sensor lane 1
		if(current & OL1)
		{
			lcd(1);
			notready();
		}
		else
		{
			lcd(1);
			ready();
		}
		if(current & OL2)
		{
			lcd(2);
			notready();
		}
		else
		{
			lcd(2);
			ready();
		}
		if(current & OL3)
		{
			lcd(3);
			notready();
		}
		else
		{
			lcd(3);
			ready();
		}
	}

	// Return zero if sensors are ready
	if(current==0)
		return 0;
	else
		return 1;
}

/*
// Lane 2 and 3
SIGNAL(SIG_PIN_CHANGE0)
{ 
	U8 pb=PINB;

	if((PINB&OL2)==0)
	{
		// Save time for lane 1
		Time_Lane_2	= TIMER_Get_Tick();
		PCMSK0 &= ~(1<< PCINT0);
		
	}

	if((PINB&OL3)==0)
	{
		// Save time for lane 1
		Time_Lane_3	= TIMER_Get_Tick();
		PCMSK0 &= ~(1<< PCINT1);
	}
}

// Only lane 1 is on this interrupt
SIGNAL(SIG_PIN_CHANGE2)
{ 
		// Save time for lane 1
	Time_Lane_1	= TIMER_Get_Tick();
	//
	// Mask off interrupt, we only want one, since this is the only interrupt on mask set to zero
	PCMSK2	=0;
}

//
// Setup interrupts on lanes 1-3, these are OL1-PD7-INT23,  OL2-PB0-INT and OL3-PB1-INT
//
void
set_pin_irq()
{
	// interrupt on any change on INT0 and INT1
	//EICRA=(1<<ISC10) | (1<< ICS00);
	// External Interrrupt MASK enable for int0 and int1
	//EIMSK=(1<<INT1) | (1<<INT0);

	// Activate Pin Change for PCIE2 (for lane 1) and PCIE0 (for lane 2 and 3)
	PCICR	=(1<<PCIE2) | (1<<PCIE0);
	//
	// enable lane 1 on PD7/INT23
	PCMSK2	=(1<<PCINT23);
	//
	// enable lane 2 (PB0) and lane 3 (PB1)
	PCMSK0 = (1<< PCINT0) | (1<<PCINT1);

	//

}
*/

int
main(void)
{
	char	key;
	U8		i=0;
	U16		time;
	U16		c;
	U8		current;

	// Setup the hardware pins
	setup_hw();
	setup_pwm();

	// Initialize the Timer
	TIMER_Init();

	// Enable the interrupts
	sei();

	// Initialize the Console Port 
	CONSOLE_init(CONSOLE_BAUD_STATIC);
	
	TIMER_Wait_Tick(20);

	//
	// Print the hello message
	//
	//TIMER_Wait_Tick(2);
	CONSOLE_puts(CRLF"FF Ver. "EM_VERSION CRLF);
	CONSOLE_puts(" -Built " __DATE__ " - " __TIME__ CRLF);
	
	TIMER_Wait_Tick(20);

	lcd(1);
	lcd_init();
	CONSOLE_puts("1");

	lcd(2);
	lcd_init();
	CONSOLE_puts("2");

	lcd(3);
	lcd_init();

	CONSOLE_puts("3");
	

  //stdout = &uart_str;
  //stderr = &lcd_str;

	lcd(1);
	LCD_puts("    Pinewood\n");
	lcd(2);
	LCD_puts("     Finish\n");
	lcd(3);
	LCD_puts("     First\n");

    // Here is the main loop, it takes commands from the serial port or the i/o interface
	//
	// The sequence of events is user resets the race, user starts the race, the race happens
	// The times are tallied and displayed and read from the serial port if needed.
	//
	// When the user resets the race, the current times are eraced and the sensors are checed for
	// ready state.  The LCD's will signal ready over each lane when ready.  A race cannot be started
	// until all lanes are rady.
	//
	// When the user starts the race with a go signal the timer is cleared to zero and starts counting.
	// When a car is detected its time is stored and displayed along with its place.
	//
	// A race is over when all 3 lanes have been triggered or the GO button is toggled again,  The Go button race end
	// can only be toggled 5 seconds after the start of a race.
	//
	Current_Time=Time_Lane_1=Time_Lane_2=Time_Lane_3=0;
	i=0;
	//wait_for_reset=1
	while(1)
	{
		TIMER_Wait_Tick(300);
		// Wait for reset
		CONSOLE_puts("Wait 4 RST"CRLF);
		while(1)
		{
			// check for reset
			if(!(PIND & eRST))
			{
				CONSOLE_puts("RstC"CRLF);
				break;
			}
			if(CONSOLE_kbhit())
			{
				// Read the key
				key=CONSOLE_getch();
				if('r'==key)
				{
					CONSOLE_puts("RstK"CRLF);
					break;
				}
				if('t'==key)
				{
					// Print times
				}
			}

		}
		
		CONSOLE_puts("Wait 4 Start"CRLF);
		check_sensors(1);
		// Check sensors and wait for GO
		while(1)
		{
			TIMER_Wait_Tick(2);
			if(0==check_sensors(0))
			{
				// Check for go button
				if(!(PIND & GO))
				{
					CONSOLE_puts("GoC"CRLF);
					break;
				}
				if(CONSOLE_kbhit())
				{
					// Read the key
					key=CONSOLE_getch();
					if('g'==key)
					{
						CONSOLE_puts("GoK"CRLF);
						break;
					}
				}
			}
		}
		TIMER_Wait_Tick(20);

		// Initialize counters to zero and start race
		Current_Time=Time_Lane_1=Time_Lane_2=Time_Lane_3=0;
		TIMER_Clear();
		while(1)
		{
			//
			// Lets not use interrupts here, just poll
			for(c=0;c<10000;c++)
			{
				// Get sensor values for this check
				current=(PIND & OL1) | (PINB & OL2) | (PINB & OL3);

		/*		if(current & OL1) putch('0');
					else putch('1');
				if(current & OL2) putch('0');
					else putch('1');
				if(current & OL3) putch('0');
					else putch('1');
				CONSOLE_puts(CRLF);
		*/	

				// Get time for this check;
				Current_Time=TIMER_Get_Tick();
				
				if(0==Time_Lane_1)
					if(current & OL1)
						Time_Lane_1=Current_Time;
				if(0==Time_Lane_2)
					if(current & OL2)
						Time_Lane_2=Current_Time;
				if(0==Time_Lane_3)
					if(current & OL3)
						Time_Lane_3=Current_Time;
			}
			
		
			// Update Time use the Current_Time from last sesnor check
			//Update_Time(Current_Time,0);
			
			// Force race end on timeout
			if(Current_Time>10000)
			{
				// Update lanes
				if(0==Time_Lane_1)
					Time_Lane_1=Current_Time;
				if(0==Time_Lane_2)
					Time_Lane_2=Current_Time;
				if(0==Time_Lane_3)
					Time_Lane_3=Current_Time;
				
				Update_Time(Current_Time,1);
				print_results();
				break;
			}


			// Check end of race, this is when all lanes have values
			if((Time_Lane_1) && (Time_Lane_2) && (Time_Lane_3))
			{
				race_order();
				Update_Time(Current_Time,1);
				print_results();
				break;
			}
			// Check user race end after 2.5 seconds
			if(Current_Time>2500)
			{
				// check for reset
				if(!(PIND & eRST))
				{
					Time_Lane_1=Time_Lane_2=Time_Lane_3=0;
					CONSOLE_puts("RstC"CRLF);
					break;
				}
				if(CONSOLE_kbhit())
				{
					// Read the key
					key=CONSOLE_getch();
					if('r'==key)
					{
						Time_Lane_1=Time_Lane_2=Time_Lane_3=0;
						CONSOLE_puts("RstK"CRLF);
						Current_Time=9999;
						Update_Time(Current_Time,0);
						break;
					}
				}
			}
		}// end race while
	}
}


