;------------------------------------------------------------------
; Everex Front Panel Display Program  for slide show
; Mike Johnson   07/21/89
; (C) July 1989  All Rights Reserved
;------------------------------------------------------------------


                .MODEL  SMALL
                .286
                .CODE
                ORG     100H

Start:          jmp     Init

                EVEN
Signature       DB      'Pslide'
Sig_Size        EQU     $-Signature
Msg1            DB      13,10,'Display is now resident.',13,10,'$'
Copy            DB      '(C) 1989 By NRG,  All Rights Reserved.',13,10,'$'
Msg2            DB      13,10,'Display is now Unloaded.',13,10,'$'
NRG             db      'NRG Soft',0
Serial_No       DB      'SN CAN-1012 ',13,10,'$'
ten             db      10
STG             DB      4000 dup(' ')
number          dw      0
pointer         DW      0
dlayval         db      4
COUNTER         DB      4
Old_Int         DD      0

;--------------------------------------------------------------------
; Procedure Banner -- our intterupt service that updates the panel
;--------------------------------------------------------------------


Banner          PROC
                pushf                           ; Save the Flags
                call    Old_Int                 ; Service old int first
                dec     cs:Counter              ; Then count delay
                jnz     Bail                    ; Bail if not ready

                call    Doit                    ; do the led update
                pusha
                mov     al,dlayval
                mov     cs:counter,al           ; restore delay counter
                popa

Bail:           iret                            ; return from intterupt
Banner          ENDP


;---------------------------------------------------------------------
;  Doit -- Updates the frount panel on the step machine
;---------------------------------------------------------------------


Doit            PROC
                pusha                           ; save registers
                push    ds                      ; save segment regs
                push    es

                mov     ax, cs                  ; setup for our varables
                mov     ds, ax
                mov     es, ax

                mov     si, offset stg
                mov     bx, pointer
                cmp     bx, number
                jg      reset
backin:         add     si,bx

                Call    WriteLED                ; write to front panel

                add     bx,8
                mov     pointer,bx

                pop     es                      ; pos segment regs
                pop     ds
                popa                            ; pop the regs and


                ret                             ; return

reset:          mov     pointer,0
                xor     bx,bx                   ; 0' bx
                jmp     backin

Doit            ENDP


;--------------------------------------------------------------------------
; WriteLED - Displays a string of 8 ASCII chars on Step LED display
; IN:        DS:SI => String
;--------------------------------------------------------------------------
WriteLED        PROC
                pushf
                cli
                pusha                           ;Save all regs

                mov     cx, 8                   ;Do 8 characters
                call    WaitFor8042             ;Wait until 8042 is empty
                mov     al, 0B0h                
                out     64h, al                 ;Set 8042 for LED output
                jmp     short WL1               ;Pause

WL1:            mov     al, cs:[si]
                inc     si
                call    WaitFor8042
                out     60h, al                 ;Send text data to LED
                jmp     short WL2               ;Pause
WL2:            loop    WL1                     ;Loop if more characters

                call    WaitFor8042
                popa                            ;Restore all regs
                popf
                retn
WriteLED        ENDP
  
;--------------------------------------------------------------------------
; WaitFor8042 - Waits until 8042 is not busy
;--------------------------------------------------------------------------
WaitFor8042     PROC    
                push    cx
                push    ax
                xor     cx,cx

WF1:            in      al,64h                  ;8042 status
                jmp     short WF2
WF2:            test    al,2
                loopnz  WF1                     ;Loop if 8042 is not empty

                pop     ax
                pop     cx
                retn
WaitFor8042     ENDP


;-----------------------------------------------------------------------
; Initilize Banner and go resident
;-----------------------------------------------------------------------

;-------------- check if already resident ------------------------------

Init:           mov     [Signature], 'p'        ;This prevents false match
                mov     dx, ds
                xor     ax, ax
                mov     es, ax

loop1:          mov     si, OFFSET Signature
                mov     di, si
                mov     cx, Sig_Size
                repe    cmpsb                   ; CMP ES:DI with Signature
                jnz     over1
                mov     si, OFFSET Signature    ; trash signature
                mov     WORD PTR es:[si],0
                jmp     Resident                ; If found Unload

over1:          inc     ax
                mov     es, ax                  ; Next segment
                cmp     dx, ax                  ; If search seg <> this seg
                jnz     loop1                   ;  keep searching
                jmp     Install                 ; Must not be installed


;-------------- Take input .. up to 4K ---------------------------------

Install:        mov     ah,7                    ; read speed
                int     21h                     ;
                sub     al,48                   ; ascII to bin
                rol     al,2                    ; Mult by 4
                mov     dlayval,al              ; store it

                mov     ah,7                    ; dump ret and lf
                int     21h
                mov     ah,7
                int     21h
get_noslides:
                call    get_slide

                mov     bx,0
                mov     ax,cx
                shl     cx,3                    ; multiply by 10
                shl     ax,1
                add     cx,ax

Readit:         mov     ah, 7                   ; Dos call for input (no echo)
                int     21h
                dec     cx
                cmp     bx, 4096                ; Reached Max input chars?
                je      exitit
                cmp     al,0ffh                 ; end of file?
                je      exitit
                cmp     cx,0
                je      exitit
                cmp     al, 32                   ; copy only valid chars
                jge     store_char
                cmp     al, 0
                jge     readit

                sub     al,128

store_char:
                mov     BYTE PTR stg[bx], al    ; Store char to our string
                inc     bx
                jmp     readit

;Backsp:         dec     bx
 ;               jmp     readit

Exitit:         mov     cx, 8
Exitloop:       mov     BYTE PTR stg[bx],' '
                inc     bx
                loop    exitloop
                mov     BYTE PTR stg[bx], 0
                sub     bx,16
                mov     number,bx


;-------------- steal int 8 --------------------------------------------

Steal:          mov     ax, 3508h               ; Get original Int 8 vector
                int     21h
                mov     WORD PTR Old_int, bx    ; save original vector
                mov     WORD PTR Old_int+2, es  ;
                mov     ax, 2508h               ; Point to new int 8 vector
                mov     dx, OFFSET Banner       ; to our new int
                int     21h


;-------------- terminate and stay resident ------------------------------


                mov     ah, 9
                mov     dx, OFFSET Msg1
                int     21h

                mov     ah,9
                mov     dx, OFFSET Copy
                int     21h

                mov     dx, OFFSET steal
                int     27h

;-------------- allready resident - unload ---------------------------

Resident:       mov     ax, 3508h                ;get int 8 vector
                int     21h
                mov      cx,ds
                mov     dx, WORD PTR es:[bx-4]   ; restore org int vect
                mov     ds, WORD PTR es:[bx-2]
                mov     ax,2508h
                int     21h
                mov     ds,cx

                lea     si,NRG
                call    writeLED

                mov     ah, 9
                mov     dx, OFFSET Msg2
                int     21h
                mov     ah, 4ch
                int     21h

get_slide:
                mov     cx,0            ; zero cx
again:
                mov     ah,7
                int     21h
                cmp     al,0ah          ; is it a lf
                je      qget
                cmp     al,47
                jle     again
                cmp     al,58
                jge     again
                sub     al,48
                xor     ah,ah
                xchg    ax,cx
                mul     ten
                add     ax,cx
                xchg    ax,cx
                jmp     again
qget:
                ret

                END     start
