;------------------------------------------------------------------
; Everex Front Panel Display Banner Program
; Mike Johnson   07/21/89
; (C) July 1989  All Rights Reserved
;------------------------------------------------------------------


                .MODEL  SMALL
                .286
                .CODE
                ORG     100H

;Start:          push ds
 ;               push es
  ;              mov  ax,cs
   ;             mov  ds,ax
    ;            mov  es,ax
START:           jmp     Init

                EVEN

Signature       DB      'Banner v1.0'
tenr            dw      10
Sig_Size        EQU     $-Signature
Msg1            DB      13,10,'Step Banner v1.0 is now resident',13,10,'$'
Copy            DB      '(C) 1989 By Mike Johnson,  All Rights Reserved',13,10,'$'
Msg2            DB      13,10,'Step Banner is already resident' ,13,10,'$'
Inmsg           DB      13,10,'Message to Display : ','$'
Old_Int         DD      0
slide           dw      0
STG             DB      'this is a test of the emergincy';4096 dup (0)
pointer         DW      0
sld_num         dw      0
COUNTER         DB      40
dlayval         db      40

;--------------------------------------------------------------------
; Procedure Banner -- our intterupt service that updates the panel
;--------------------------------------------------------------------


Banner          PROC
                pushf                           ; Save the Flags
                call    Old_Int                 ; Service old int first

                dec     cs:Counter              ; Then count delay
                jnz     Bail                    ; Bail if not ready
                cli
                call    Doit                    ; do the led update
                sti
                mov     al,cs:dlayval           ; restore delay counter
                mov     cs:counter,al
Bail:           iret                            ; return from intterupt
Banner          ENDP


;---------------------------------------------------------------------
;  Doit -- Updates the frount panel on the step machine
;---------------------------------------------------------------------


Doit            PROC   near
                pusha                           ; save registers
                push    ds                      ; save segment regs
                push    es
                mov     ax, cs                  ; setup for our varables
                mov     ds, ax
                mov     es, ax

                cld

                mov     bx, pointer             ; move stg pointer to bx

                mov     si, OFFSET stg
                mov     dx, sld_num

                cmp     dx,slide
                je      Reset                   ; Reset counter

                inc     sld_num
                add     si,bx                   ; setup for call to write
Backin:         Call    TempWrite               ; write to Screen
;Backin:         Call    WriteLED                ; write to front panel

                add     pointer,8

                pop     es                      ; pos segment regs
                pop     ds
                popa                            ; pop the regs and


                retn                            ; return

Reset:          mov     pointer, 0              ; reset pointer
                mov     sld_num, 0
                jmp     backin                  ; write led
Doit            ENDP






;--------------------------------------------------------------------------
; WriteLED - Displays a string of 8 ASCII chars on Step LED display
; IN:        DS:SI => String
;--------------------------------------------------------------------------
WriteLED        PROC   near
                cli
                pusha                           ;Save all regs

                mov     cx, 8                   ;Do 8 characters
                call    WaitFor8042             ;Wait until 8042 is empty
                mov     al, 0B0h                
                out     64h, al                 ;Set 8042 for LED output
                jmp     short WL1               ;Pause

WL1:            mov     al, cs:[si]
                inc     si
                call    WaitFor8042
                out     60h, al                 ;Send text data to LED
                jmp     short WL2               ;Pause
WL2:            loop    WL1                     ;Loop if more characters

                call    WaitFor8042
                popa                            ;Restore all regs
                retn
WriteLED        ENDP

  
;--------------------------------------------------------------------------
; WaitFor8042 - Waits until 8042 is not busy
;--------------------------------------------------------------------------
WaitFor8042     PROC    near
                push    cx
                push    ax
                xor     cx,cx

WF1:            in      al,64h                  ;8042 status
                jmp     short WF2
WF2:            test    al,2
                loopnz  WF1                     ;Loop if 8042 is not empty

                pop     ax
                pop     cx
                retn
WaitFor8042     ENDP



;------------------------------------------------------------------------
; TEmPWRITE -- Simulates a step led display on the screen
; String to be displayed is in DS:SI on entry
;------------------------------------------------------------------------
TempWrite	PROC
                pushf
      ;         pusha
                mov     ax, 0B800h              ; Mem loc for video
                mov     es, ax                  ; Move it into extra seg
                mov     cx, 8                   ; setup for 8 char

                xor     di, di
                mov     ah, 1Eh                 ; set video attribute
Again:          lodsb                           ; load al with ascii char
                stosw                           ; store to screen
                loop again                      ; 'tell 8 chars are done
       ;        popa
                popf
                ret
TempWrite	ENDP

;
;
;--------------- input integer - return in cx ----
; later try to save envirnmt

;
INPUT           PROC  NEAR

                mov   cx,0              ; zero return reg

l1:             mov   ah,7              ; Get character
                int   21h
                inc   bx                ; inc instring pointer

;                mov dl,al               ; echo it
 ;               mov ah,2
  ;              int 21h

                cmp   al,13             ; bail on return
                je    endinp
                cmp   al,30h            ; Make sure its a digit
                jl    l1                ; if junk bail
                cmp   al,39h
                jg    l1
                push  ax                ; another digit
                mov   ax,cx             ; shift val left a tens dig
                mul   tenr
                mov   cx,ax
                pop   ax
                sub   al,30h            ; convert ascII to bin
                cbw                     ; line up bits for add
                add   cx,ax             ; add in new ones digit

                jmp   l1                ; go and read next char

endinp:         ret
INPUT           ENDP



; REGDUMP       -- BY MIKE JOHNSON OCT. 5 1989
;
; converts a 16-bit in AX to ASCII string and
; writes it to the screen.
;
; On entry AX is value to be dumped.
;
; On exit registers are unchanged is destroyed.
;


REGDUMP         PROC NEAR
                jmp     odata
DSTR            DB      '               '

TEN             DW      10                  ; WORD THAT = 10 FOR %



odata:          pushf                       ; Save flags
                PUSHA                       ; save all regs .286 style
                mov     dx,10               ; end ptr for stack str
                push    dx
SHOWL1:         MOV     DX, 0               ; CLEAR MSB OF DIVIDEND
                DIV     TEN                 ; FIND REMAINDER FOR DIGIT
                ADD     dx,48               ; CONVERT TO ASCII Char
                push    dx                  ; push Char to stack
                CMP     AX,0                ; Any digits left?
                JNE     SHOWL1              ; Well get'em then..

                mov     si,0                ; set str ptr to 0
popit:          pop     AX                  ; pop char from stack
                mov     BYTE PTR dstr[si],AL ;save it in our string
                inc     si                  ; next str pos
                cmp     ax,10               ; or was that the end
                jne     popit               ; no popit again
                mov     BYTE PTR dstr[si],13 ; yes add a return
                inc     si
                mov     BYTE PTR dstr[si],'$'; and a string terminator

                MOV     AH,9                ; write the bitch
                MOV     DX, OFFSET DSTR
                INT     21H

                POPA                        ; restore enviornment
                popf
                RET


REGDUMP         ENDP




;-----------------------------------------------------------------------
; Initilize Banner and go resident
;-----------------------------------------------------------------------

;-------------- check if already resident ------------------------------

Init:           mov     [Signature], 'b'        ;This prevents false match
                mov     dx, ds
                xor     ax, ax
                mov     es, ax

loop1:          mov     si, OFFSET Signature
                mov     di, si
                mov     cx, Sig_Size
                repe    cmpsb                   ; CMP ES:DI with Signature
                jz      install                 ; If found exit program

                inc     ax
                mov     es, ax                  ; Next segment
                cmp     dx, ax                  ; If search seg <> this seg
                jnz     loop1                   ;  keep searching
                jmp     Install                 ; Must not be installed


;-------------- Take input .. up to 4K ---------------------------------


install:        mov     ah,7                   ; Read Speed
                int     21h                    ; and convet to bin
                sub     al,48
                rol     al,2
                mov     al,8
                mov     dlayval,al             ; store dlay val

                mov     ah,7                   ; dump return
                int     21h                    ; we don't need it
                mov     ah,7                   ; dump linefeed
                int     21h

                call    INPUT                  ; get frames
                                               ; ret in cx
                mov     ah,7                   ; dump ret
                int     21h

                mov     slide,2               ; store no of slides
                mov     dx,cx                  ; set up for reading slides
                jmp     exitit
                mov     bx,0
startread:      cmp     dx,0
                je      exitit
                mov     cx,8
readsld:        mov     ah,7                   ; Read SLD
                int     21h
                cmp     al,127
                jg      readsld
                mov     BYTE PTR stg[bx],al
                inc     bx

;                push    dx
 ;               mov     ah,2
  ;              mov     dl,al
   ;             int     21h
    ;            pop     dx

                loop    readsld

                mov     ah,7                    ; dump ret
                int     21h
                mov     ah,7                    ; dump linefeed
                int     21h

                dec     dx
                jmp      startread

Exitit:         mov     cx, 8
Exitloop:       mov     BYTE PTR stg[bx],' '
                inc     bx
                loop    exitloop

;-------------- steal int 8 --------------------------------------------

Steal:          mov     ax, 3508h               ; Get original Int 8 vector
                int     21h
                mov     WORD PTR Old_int, bx    ; save original vector
                mov     WORD PTR Old_int+2, es  ;
                mov     ax, 2508h               ; Point to new int 8 vector
                mov     dx, OFFSET Banner       ; to our new int
                int     21h


;-------------- terminate and stay resident ------------------------------


                mov     ah, 9
                mov     dx, OFFSET Msg1
                int     21h

                mov     ah,9
                mov     dx, OFFSET Copy
                int     21h

                mov     dx, OFFSET Install
                int     27h

;-------------- allready resident - terminate ---------------------------

Resident:       mov     ah, 9
                mov     dx, OFFSET Msg2
                int     21h
                pop es
                pop ds
                mov     ah, 4ch
                int     21h




                 










                END     start
