;--------------------------------------------------------------------------
; Everex Step computer LED clock test program
; Mike Johnson (C) 06/13/89 All Rights Reserved
;      03/01/90 distribution version
;--------------------------------------------------------------------------

                .MODEL   SMALL
		.286


interrupts segment at 0h
           org   08h*4
timer_int  label dword
interrupts ends

                .CODE

                ORG     100h


Start:          jmp     Init

		EVEN
Signature       DB      'pclock v1.1'
Sig_Size        EQU     $-Signature
Copyright       db      'Pclock Copyright (C)1989 by NRG',13,10,'$'
Copyright1      db      'All Rights Reserved.',13,10,'$'
sn              db      'SN CAN-1001 ',0
h12             db      'Now in 12 hour mode.',13,10,'$'
h24             db      'Now in 24 hour mode.',13,10,'$'
pan             db      'NRG Soft',0
Msg1            DB      'Pclock v1.1 is now resident',13,10,'$'
Msg2            DB      'Pclock is now silent      ' ,13,10,'$'
msg3            DB      'Pclock is now active',13,10,'$'
msg4            db      'Pclock is now unloaded',13,10,'$'
ClockStr        DB      '00:00:00'
Hour            DB      0
Mins		DB	0
Secs		DB	0
Count5		DB	5
Count18         DB      1			;Must be >0 for ISR08
Old_ISR08       DD      0
mode            dw      0
silent          dw      1

;--------------------------------------------------------------------------
; Int 8 ISR - Chains onto Int 8 and updates our clock every 18 counts
;             Counter must be set to 1 before installed
;--------------------------------------------------------------------------
ISR08		PROC
                pushf
		call	Old_ISR08      	
	        dec     cs:Count18   	        ;DEC counter 18.2/sec
		jnz	Exit_ISR08              ;If 1 sec is up
		call	LEDClock                ; do LEDClock
                mov     cs:Count18, 18          ;Reset counter
		dec	cs:Count5
		jnz	Exit_ISR08
		inc	cs:Count18
		mov	cs:Count5, 5
Exit_ISR08:	iret
ISR08		ENDP

;--------------------------------------------------------------------------
; LEDClock - Main resident routine to display clock on LED's
;--------------------------------------------------------------------------
LEDClock        PROC
		pusha
		push	ds
		push	es

		mov	ax, cs
		mov	ds, ax
		mov	es, ax
		cld
		
;-------------- Seconds ---------------------------------------------------

		mov	al, [Secs]
		inc	al
		cbw
		mov	cl, 60
		div	cl
                mov	[Secs], ah
		mov	dl, al
		mov	di, OFFSET ClockStr +6
		call	Bin2Ascii

;-------------- Minutes ---------------------------------------------------
               		
		mov	al, [Mins]
		add	al, dl
		cbw
  		div	cl
		mov	[Mins], ah
		mov	dl, al
		mov	di, OFFSET ClockStr +3
		call	Bin2Ascii

;-------------- Hours -----------------------------------------------------

		mov	al, [Hour]
		add	al, dl
		cbw
                mov     bx,ax
                mov     cl,24
                div     cl
                mov     [hour],ah
                cmp     cs:mode,1
                je      movhr
                mov     ax,bx
                mov     cl,12
                div     cl
                cmp     ah,0
                jne     movhr
                mov     ah,12

movhr:          mov     di, OFFSET ClockStr
 		call	Bin2Ascii

                mov	si, OFFSET ClockStr
                cmp     silent,0
                jz      done
                call    WriteLED
;***            call    TempWrite
done:           pop     es
		pop	ds
		popa
		ret
LEDClock        ENDP

;--------------------------------------------------------------------------
; Function: Converts a 8 bit binary number to ASCII decimal. 		
; Input:    AL=Number to convert, ES:DI => String dest, clear dir flag
;--------------------------------------------------------------------------
Bin2Ascii       PROC
		mov	al, ah
		cbw		
		mov	bl, 10			;Divide by radix 10        	
B2A:     	div	bl
		add	ax, 3030h               ;Add 30h for ASCII
		stosw                           ;Put ASCII digit in string
		ret
Bin2Ascii	ENDP



;--------------------------------------------------------------------------
; WriteLED - Displays a string of 8 ASCII chars on Step LED display
; IN:        DS:SI => String
;--------------------------------------------------------------------------
WriteLED        PROC
                pushf
                cli
                pusha                           ;Save all regs

                mov     cx, 8                   ;Do 8 characters
                call    WaitFor8042             ;Wait until 8042 is empty
                mov     al, 0B0h                
                out     64h, al                 ;Set 8042 for LED output
                jmp     short WL1               ;Pause

WL1:            mov     al, cs:[si]
                inc     si
                call    WaitFor8042
                out     60h, al                 ;Send text data to LED
                jmp     short WL2               ;Pause
WL2:            loop    WL1                     ;Loop if more characters

                call    WaitFor8042
                popa                            ;Restore all regs
                popf
                retn
WriteLED        ENDP
  
;--------------------------------------------------------------------------
; WaitFor8042 - Waits until 8042 is not busy
;--------------------------------------------------------------------------
WaitFor8042     PROC    
                push    cx
                push    ax
                xor     cx,cx

WF1:            in      al,64h                  ;8042 status
                jmp     short WF2
WF2:            test    al,2
                loopnz  WF1                     ;Loop if 8042 is not empty

                pop     ax
                pop     cx
                retn
WaitFor8042     ENDP
 

TempWrite	PROC
		mov	ax, 0B800h
		mov	es, ax
		mov	cx, 8
		xor	di, di
		mov	ah, 1Eh
Again:		lodsb
		stosw
	                  ;	dec	cx
		loop again       ;jnz	Again
		ret
TempWrite	ENDP

;==========================================================================

;-------------- CHECK IF ALREADY RESIDENT ---------------------------------

load_clock      proc near
                assume  ds:interrupts
Init:           pusha
                mov     si, 0081h               ; addr of command line arg
next:           mov     al, cs:[si]             ; get command line char
                cmp     al, 0dh                 ; Return ends it.
                jz      fsig
                cmp     al,'\'                  ; Switch char
                jz      getswitch               ; See What it is
                cmp     al,'/'
                jz      getswitch
next1:          inc     si                      ; else point to next char
                jmp     next                    ; and loop

getswitch:      inc     si
                mov     al, cs:[si]             ; Right Switch?
                cmp     al, 'm'
                je      tog_24                  ; is a change format
                cmp     al,'u'
                jne     next1                   ; is it an unload
                mov     mode,9
                jmp     fsig                    ; unload clock

tog_24:
                mov     mode,1                  ; toggle switch

fsig:           mov     [Signature], 'P'        ;This prevents false match
		mov	dx, ds
		xor	ax, ax
                mov	es, ax

Loop1:		mov	si, OFFSET Signature
		mov	di, si
                mov     cx, Sig_Size
		repe	cmpsb                   ;CMP ES:DI with Signature
		jz	Resident                ;If found exit program

SkipJmp:        inc	ax
                mov     es, ax                  ;Next segment
               	cmp	dx, ax			;If search seg <> this seg
	        jnz	Loop1                   ; keep searching
                jmp	Install                 ;Must not be installed


;-------------- STEAL INT 08 ----------------------------------------------

Install:        mov     ax, 3508h               ;Get original Int 08 vector
		int	21h
		mov	WORD PTR Old_ISR08,  bx ;Save original vector
                mov	WORD PTR Old_ISR08+2,es
		mov	ax, 2508h               ;Point Int 08h vector to
                mov     dx, OFFSET ISR08        ; new ISR08
                int     21h

;-------------- GET TIME AND STORE TIME --------------------------------------

		mov	ah, 2Ch
		int	21h
		mov	Hour, ch
		mov	Mins, cl
		mov	Secs, dh

;-------------- TERMINATE AND STAY RESIDENT ----------------------------------

                popa
                mov     ah, 9
                mov     dx, OFFSET copyright
                int     21h
                mov     dx, OFFSET copyright1
                int     21h
	  	mov	dx, OFFSET Msg1
		int	21h
		mov	dx, OFFSET Install
		int	27h
                	
;-------------- TERMINATE ----------------------------------------------------


Resident:
                cmp     cs:mode,9
                je      unload_clk
                mov     ax, 3508h               ; get inttrupt 08 vector
                int     21h
                cmp     mode,1
                jne     toggleact
                cmp     word ptr es:[bx-4],0    ; cmp mode to 0
                je      twofour

                mov     word ptr es:[bx-4],0    ; set mode to 0
                mov     ah, 9
                mov     dx, offset h12
                int     21h
                jmp     bail



twofour:        mov     word ptr es:[bx-4],1    ;
                mov     ah, 9
                mov     dx, offset h24
                int     21h
                jmp     bail


toggleact:      cmp     word ptr es:[bx-2],0
                je      resmsg1

                mov     word ptr es:[bx-2],0

                mov     ah, 9
                mov     dx, OFFSET msg2
                int     21h

bail:           mov     si, offset pan
                call    writeled
                popa
                mov     ah, 4ch
                int     21h

resmsg1:        mov     word ptr es:[bx-2],1
                popa
                mov     ah, 9
                mov     dx, OFFSET Msg3
		int	21h
          	mov	ah, 4Ch
		int	21h

unload_clk:
                mov     si, OFFSET Signature    ; Kill signature and unload
                mov     WORD PTR es:[si],0
                mov     ax, 3508h               ; get int 8 vector
                int     21h
                mov     cx,ds
                mov     dx, WORD PTR es:[bx-08h]  ; restore org int vector
                mov     ds, WORD PTR es:[bx-06h]
                mov     ax, 2508h
                int     21h
                mov     ds,cx

                lea     si,pan
                call    writeLED

                mov     ah, 9
                mov     dx, OFFSET Msg4
                int     21h
                mov     ah, 4ch
                int     21h

load_clock      endp
		END	Start
