';------------------------------------------------------------------
; Banner4k  --> display up to 4k of text to the everex panel
;
; Everex Front Panel Display Banner Program
; Mike Johnson   07/21/89
; (C) July 1989  All Rights Reserved
;------------------------------------------------------------------


                .MODEL  SMALL
                .286
                .CODE
                ORG     100H

Start:          jmp     Init

                EVEN
Signature       DB      'Banner v1.0'
Sig_Size        EQU     $-Signature
Msg1            DB      13,10,'Banner4k v1.0 is now resident',13,10,'$'
Copy            DB      '(C) 1989 By NRG,  All Rights Reserved',13,10,'$'
Msg2            DB      13,10,'Banner4k is now unloaded.' ,13,10,'$'
Inmsg           DB      13,10,'Message to Display : ','$'
Serial_No       DB      'SN CAN-1010 ',13,10,'$'
NRG             db      'NRG Soft',0
STG             DB      4096 dup(' ')
pointer         DW      0
COUNTER         DB      5
Old_Int         DD      0

;--------------------------------------------------------------------
; Procedure Banner -- our intterupt service that updates the panel
;--------------------------------------------------------------------


Banner          PROC
                pushf                           ; Save the Flags
                call    Old_Int                 ; Service old int first
                dec     cs:Counter              ; Then count delay
                jnz     Bail                    ; Bail if not ready

                call    Doit                    ; do the led update

                mov     cs:counter,5            ; restore delay counter

Bail:           iret                            ; return from intterupt
Banner          ENDP


;---------------------------------------------------------------------
;  Doit -- Updates the frount panel on the step machine
;---------------------------------------------------------------------


Doit            PROC
                pusha                           ; save registers
                push    ds                      ; save segment regs
                push    es

                mov     ax, cs                  ; setup for our varables
                mov     ds, ax
                mov     es, ax
                cld

                mov     bx, pointer             ; move stg pointer to bx
                mov     si, OFFSET stg
                cmp     BYTE PTR stg[bx+8],0   ; End of stg encountered?
                je      Reset                   ; Reset counter
                add     si,bx                   ; setup for call to write
;Backin:         Call    TempWrite               ; write to Screen
backin:         Call    WriteLED                ; write to front panel
                inc     pointer                 ; advance the pointer

                pop     es                      ; pos segment regs
                pop     ds
                popa                            ; pop the regs and


                ret                             ; return

Reset:          mov     pointer, 0              ; reset pointer
                jmp     backin                  ; write led
Doit            ENDP






;--------------------------------------------------------------------------
; WriteLED - Displays a string of 8 ASCII chars on Step LED display
; IN:        DS:SI => String
;--------------------------------------------------------------------------
WriteLED        PROC
                pushf
                cli
                pusha                           ;Save all regs

                mov     cx, 8                   ;Do 8 characters
                call    WaitFor8042             ;Wait until 8042 is empty
                mov     al, 0B0h                
                out     64h, al                 ;Set 8042 for LED output
                jmp     short WL1               ;Pause

WL1:            mov     al, cs:[si]
                inc     si
                call    WaitFor8042
                out     60h, al                 ;Send text data to LED
                jmp     short WL2               ;Pause
WL2:            loop    WL1                     ;Loop if more characters

                call    WaitFor8042
                popa                            ;Restore all regs
                popf
                retn
WriteLED        ENDP
  
;--------------------------------------------------------------------------
; WaitFor8042 - Waits until 8042 is not busy
;--------------------------------------------------------------------------
WaitFor8042     PROC    
                push    cx
                push    ax
                xor     cx,cx

WF1:            in      al,64h                  ;8042 status
                jmp     short WF2
WF2:            test    al,2
                loopnz  WF1                     ;Loop if 8042 is not empty

                pop     ax
                pop     cx
                retn
WaitFor8042     ENDP


;-----------------------------------------------------------------------
; Initilize Banner and go resident
;-----------------------------------------------------------------------

;-------------- check if already resident ------------------------------

Init:           mov     [Signature], 'b'        ;This prevents false match
                mov     dx, ds
                xor     ax, ax
                mov     es, ax

loop1:          mov     si, OFFSET Signature
                mov     di, si
                mov     cx, Sig_Size
                repe    cmpsb                   ; CMP ES:DI with Signature
                jz      Resident                ; If found exit program

                inc     ax
                mov     es, ax                  ; Next segment
                cmp     dx, ax                  ; If search seg <> this seg
                jnz     loop1                   ;  keep searching
                jmp     Install                 ; Must not be installed


;-------------- Take input .. up to 4K ---------------------------------

Install:
                mov     bx, 8                   ; Leave 8 Blanks
Readit:         mov     ah, 7                   ; Dos call for input
                int     21h

                cmp     bx, 4095                ; Reached Max input chars?
                je      exitit
                cmp     al, '|'                 ; Terminate on pipe
                je      exitit
                cmp     al, 32                  ; copy only valid chars
                jl      readit
                cmp     al, 127
                jg      readit

                mov     BYTE PTR stg[bx], al    ; Store char to our string
                inc     bx
                jmp     readit

Backsp:         dec     bx
                jmp     readit

Exitit:         mov     cx, 8
Exitloop:       mov     BYTE PTR stg[bx],' '
                inc     bx
                loop    exitloop
                mov     BYTE PTR stg[bx], 0



;-------------- steal int 8 --------------------------------------------

Steal:          mov     ax, 3508h               ; Get original Int 8 vector
                int     21h
                mov     WORD PTR Old_int, bx    ; save original vector
                mov     WORD PTR Old_int+2, es  ;
                mov     ax, 2508h               ; Point to new int 8 vector
                mov     dx, OFFSET Banner       ; to our new int
                int     21h


;-------------- terminate and stay resident ------------------------------


                mov     ah, 9
                mov     dx, OFFSET Msg1
                int     21h

                mov     ah,9
                mov     dx, OFFSET Copy
                int     21h

                mov     dx, OFFSET Install
                int     27h

;-------------- allready resident - unload    ---------------------------

Resident:       mov     si, OFFSET Signature     ; kill signature
                mov     WORD PTR es:[si],0       ; and reset int 8
                mov     ax, 3508h                ; get int 8 vector
                int     21h
                mov     cx,ds
                mov     dx, WORD PTR es:[bx-4]   ; restore org int vect
                mov     ds, WORD PTR es:[bx-2]
                mov     ax, 2508h
                int     21h
                mov     ds,cx

                lea     si,NRG
                call    writeLED
                mov     ah, 9
                mov     dx, OFFSET Msg2
                int     21h
                mov     ah, 4ch
                int     21h


                END     start
