//
// Tick.c - Tick routine for the ibud + IAR tools.
//                                                                            
//  Created Oct 25, 1998 MWJ iReady Co.
// 
#include <stdio.h>
#include <intrz80.h>   
#include <imin.h>  
#include <ibud.h>            

/*
//  ibud timer init.
*/
void
imin_SysInit()        
{
char  temp;
  //
  // Set tick interrupt channel to vector 0x04 (z180 like) and enable it.
  //         
  p0out(INTVX3,0x04);                     
  temp=p0in(INTXEN);
  p0out(INTXEN,temp | Int3_EN);   
  //p0out(INTC,INT_En);
  //
  // Set clock divide to 2
  //                      
  p0out(CDIV,2); 
  //
  // Set timer count to 0xff00
  // 
  p0out(TIMC0,0);
  p0out(TIMC1,0);
  p0out(TIMC2,20);
  p0out(TIMC3,0);
  //
  // Initialize Timer for Looping, Interrupts and enable it.
  //  
  p0out(TIMC, TIMC_Loop | TIMC_En | TIMC_IntEn);   
}



void
imin_Shutdown()
{
	/* turn off the tick interrupt */
}