/* imin.h - Mike Johnson iReady */
#ifndef IMIN_H
#define IMIN_H
/*
**
**
**
*/
#include <itypes.h>

/*
** Include system dependent imin stuff here.
*/
#if (CPU==X86)
    #include "../x86/imin86.h"
#endif
    
#if (CPU==Z80)   
	#include "../z80/iminz80.h"
#endif    

/*                                                    */
/* Define the number of callbacks and timer callbacks */
/*                                                    */
#define         MAX_CALLBACKS   8
#define         MAX_TCALLBACKS  4

typedef S16 (*CB_FUNC)(void*);

typedef struct CALLBACK_
{
    struct CALLBACK_    *next;
    U16                 priority;
    CB_FUNC             function;
    void                *call_ptr;
    U8                  incall;
}CALLBACK;

typedef struct TCALLBACK_
{
    struct TCALLBACK_   *next;
    S16                 period;
    S16                 nexttime;
    CB_FUNC             function;
    void                *call_ptr;
}TCALLBACK;


/*
**
*/
void *cbadd(U8 priority, CB_FUNC, void *);
int cbRemove(void *);

void *tcbAdd(U16 how_often, CB_FUNC, void *);
int tcbRemove(void *, CB_FUNC);


S16 imin_ticCnt(void);


#endif

