#ifndef SHELL_H
#define SHELL_H
/************************************************************************
*
* Copyright (c) 1997 iReady Corporation
*
* All information contained in this file is proprietary to iReady
* Corporation and may not be reproduce, distributed or disseminated,
* in whole or in any part, without written permission of an authorized
* representative of iReady Corporation.
*
* NAME                               									
*   iface.h
*
* DESCRIPTION
*
* Revision 1.0  10/16/97 M. Johnson
*   Original Program.
*
************************************************************************/   

#include <stdio.h>

#define	BELL	0x07
#define	BKSP	0x08
#define	RET		0x0d
#define ESC		0x1b
#define	DEL		0x7f  


typedef struct	SH_CMD_
{
	struct SH_CMD_		*next;
	U8					*cmd;
	void				(*handler)(U8 **, U8);
}SH_CMD;



S16		get_command(U8 *);
S16		SH_command_processor();
void	SH_Refresh();
BOOLEAN	SH_Register(SH_CMD *);
BOOLEAN	SH_DeRegister(SH_CMD *);

BOOLEAN SH_Init(void);
void	SH_Prompt(U8 *);

void	SH_Help(U8 **, U8);
void	SH_Exit(U8 **, U8);   
void	SH_ExecScript(U8 **, U8);
//
// Utilities that should be in their own file
//        							     
BOOLEAN readln_from_a_file(FILE *, U8 *);
             
#endif             

