/************************************************************************
*
* Copyright (c) 1997,99 iReady Corporation
*
* All information contained in this file is proprietary to iReady
* Corporation and may not be reproduce, distributed or disseminated,
* in whole or in any part, without written permission of an authorized
* representative of iReady Corporation.
*
* NAME                               									
*   shell.c	- Very Simple Command Processor Shell for the Test Router.
*
* DESCRIPTION
*
* Revision 1.0  01/02/97 M. Johnson
*   Original Program.               
* Revision 1.0a 01/06/99 M. Johnson
*	Modified for the AIM client.
*                               										
************************************************************************/

#include <stdlib.h>
#include <stdio.h>   
#include <string.h>    
#include <conio.h>
#include "aim.h"
#include "shell.h"   

#define	MAX_PROMPT		30          
#define DEFAULT_PROMPT	"#"

static BOOLEAN	SH_Initialized=IFALSE;
static SH_CMD	*shell_command_list=NULL;
static U8		exit_sh=0;  

static U8		prompt[MAX_PROMPT];
static U8       command_str[129];
//
//
//
static SH_CMD	exit_cmd;
static SH_CMD	help1_cmd;
static SH_CMD	help2_cmd; 
static SH_CMD	exec_cmd;
//
// Initialize the shell
//
BOOLEAN
SH_Init()
{
	//
	if(SH_Initialized==ITRUE)
	{
	  	//DEBUG(SHELL_DEBUG,"SH_Init: Already Initialized.\n");
	  	return(IFALSE);
	} 
	//
	// Set to shell not exit.
	//
	exit_sh=0;             
	//
	// Set Default Prompt
	//                   
	strcpy(prompt,DEFAULT_PROMPT);
	//
	// null command string
	//
	command_str[0]=0;
	//
	// Initialize starting shell commands.
	//                                    
	exit_cmd.cmd="exit";
	exit_cmd.handler=&SH_Exit;
	help1_cmd.cmd="?";
	help1_cmd.handler=&SH_Help;
	exec_cmd.cmd="exec";
	exec_cmd.handler=&SH_ExecScript;
	//
	// Initialize shell command list to starting value, and register
	//	help commands.
	//		
	shell_command_list=NULL;
	//
	SH_Initialized=ITRUE;  
	SH_Register(&exit_cmd);
	SH_Register(&help1_cmd);
	SH_Register(&exec_cmd);												
    //
    //
    //
	return(ITRUE);
}

void
SH_Prompt(new_prompt)
U8	*new_prompt;
{        

	if(new_prompt==NULL)
	{
		//
		// Set Default Prompt
		//                   
		strcpy(prompt,DEFAULT_PROMPT);		
	}
	else        
    { 
    	strncpy(prompt,new_prompt,MAX_PROMPT);
    	prompt[MAX_PROMPT]=0;
    }    
}

//
// DeRegister a command with the shell
//  
BOOLEAN
SH_DeRegister(cmd)
SH_CMD	*cmd;
{   
SH_CMD  *tmp;
	//
	if(SH_Initialized==IFALSE)
	{
		//DEBUG(SHELL_DEBUG,"SH_Register: Shell not initialized.\n");
		return(IFALSE);
	}
	//
	if(cmd==shell_command_list)
	{
		shell_command_list=cmd->next;
	}                            
	else
	{
		tmp=shell_command_list;
		while((tmp->next!=cmd) && (tmp->next!=NULL))
			tmp=tmp->next;
		if(tmp->next!=NULL)
			tmp->next=cmd->next;								
	}
	
	return(IFALSE);
}

//
// Register a command with the shell
//  
BOOLEAN
SH_Register(cmd)
SH_CMD	*cmd;
{           
	//
	//
	if(SH_Initialized==IFALSE)
	{
		//DEBUG(SHELL_DEBUG,"SH_Register: Shell not initialized.\n");
		return(IFALSE);
	}                  
	//
	// For now just add command to head of list, later we can
	// sort it.
	//         
	cmd->next=shell_command_list;
	shell_command_list=cmd;
	//
	//
	//
	return(ITRUE);
}


void
SH_Refresh()
{
	printf("\n%s%s",prompt,command_str);
}

//
// 
//
S16
get_command(command)
U8		*command;
{
U16	exit=0;           
static U16	clen=0;  
U16			tlen;
U16	iskey;
U8	ikey;

	iskey = _kbhit();
	if(iskey)
	{
		ikey=getch(); 
		if(ikey==0)
		{
			ikey=getch();
			if(ikey==0x4b)
				ikey=0x08;
		}	  
		if(ikey==RET)
		{        
			command[clen]=0;
			tlen=clen; 
			clen=0;   
			if(tlen==0)
				printf("\n%s",prompt);
			return(tlen);
		}
		if(ikey==BKSP)
		{      
			if(clen)
			{
				printf("%c %c",BKSP,BKSP);
				clen--;
				command[clen]=0;
			}
			else
				printf("%c",BELL);
		}
		else
		if(clen<128)
		{
			printf("%c",ikey);
			command[clen++]=ikey;
			command[clen]=0;
		}
	}
	return(0);
}                  




//
//
//
S16
process_command(command_str)
U8	*command_str;
{ 
SH_CMD	*tcmd;
U8		*command_list[80];
U8		num_commands;
U8		*ptr;      
// Dan: U8		c;
// Dan: U16		i;
 
 	//
 	// find the command
 	//              
 	num_commands=0;
 	ptr=command_str;               
 	while(ptr)
 	{              
 		command_list[num_commands++]=ptr;
 		ptr=strpbrk(ptr," ");
 		if(ptr!=NULL)   
		{
 			command_str[ptr-command_str]=0;
 			ptr++;
 		}
 	}
    printf("\n");
	if(num_commands==0)
		return(0);
   	//
	// Go through and take action on the command.
	//
	tcmd=shell_command_list;
	while(tcmd)
	{   
		if(strcmp(command_list[0],tcmd->cmd)==0)
		{                   
			tcmd->handler(command_list,num_commands); 
			break;
		}
		else
			tcmd=tcmd->next;
	}  
	//
	//
	//
	if(tcmd==NULL)
	{
		printf("Command '%s' not known, type ? for commmand list.\n",command_list[0]);
		command_str[0]=0;
		return(-1);
	}
	command_str[0]=0;
	return(0);
}	               
 
BOOLEAN 
SH_Exec_Init()
{      
U8		*command_list[2];
	//
	//
	//
	if(SH_Initialized==IFALSE)
	{
		//DEBUG(SHELL_DEBUG,"SH_command_processor: shell not initialized.\n");
		return(IFALSE);
	}                  
	//
	// Run the default initial shell script for confirutation.
	//                  
	command_list[0]="exec";
	command_list[1]="aim.ini";                  
	SH_ExecScript(command_list,2);          
	return(ITRUE);
}





S16
SH_command_processor()
{       
	//
	//
	//
	if(SH_Initialized==IFALSE)
	{
		//DEBUG(SHELL_DEBUG,"SH_command_processor: shell not initialized.\n");
		return(IFALSE);
	}                  

	if(get_command(command_str)!=0)   
	{
	    process_command(command_str);
    	printf(prompt);
    }
    
	if(exit_sh)
		return(IFALSE);
	else
		return(ITRUE);	
}




void
SH_Help(command_list,num_commands)
U8		*command_list[];
U8		num_commands;
{        
SH_CMD	*tcmd;
	//
	//
	//
	printf("Command List\n");
	//
	// Printout a list of registered commands
	//    
	tcmd=shell_command_list;
	while(tcmd)
	{   
		if(tcmd!=shell_command_list)
			printf(", ");
		printf("%s",tcmd->cmd);
		tcmd=tcmd->next;	
	}                   
	printf("\n");
    
} 


void
SH_Exit(command_list,num_commands)
U8		*command_list[];
U8		num_commands;
{        
	//
	// Set the shell exit flag.
	//
	printf("Exiting...\n");  
//	TOC_Disconnect(connection);	
	CMD_Logout(command_list,num_commands);
    exit_sh=1;
} 


//
//
//
void
SH_ExecScript(command_list,num_commands)
U8		*command_list[];
U8		num_commands;
{              
U8		command_str[128];
FILE	*script_file;
	//
	// Command format is "exec filename"
	//                                  
	if(num_commands!=2)
	{
		printf("exec filename.\n");
		return;
	}          
	//
	// Try to open the file.
	//                      
	if(NULL==(script_file=fopen(command_list[1],"r")))
    { 
    	printf("Script File %s does not exist or cannot be opened.\n",
     			command_list[1]);
    	return;		
    }	       
    //
    // File is open, start reading lines and processing them.
    //           
    printf("\nRunning script %s.\n",command_list[1]);                                            
    while(readln_from_a_file(script_file,command_str)!=IFALSE)
	{	
		printf(">%s",command_str);
		process_command(command_str);    
    }
    printf("Finished running the script %s.\n\n",command_list[1]);
    //
    // Close the file and return
    //                          
    fclose(script_file);
    return;
}

 

//----------------------------------------------------------------------
// readln_from_a_file(fp,lin) - reads a line from file (fp) and
//  places it in lin.  Returns 0 for no lines left and 1 for
//  line was read.
//-----------------------------------------------------------------------
BOOLEAN
readln_from_a_file(FILE *fp, U8 *lin)
{
        char *p;
  
        do
                p = fgets( lin, 127, fp );
        while( ( p != NULL ) && ( *lin == '#') );

        if( p == NULL )
                return(IFALSE);
        if (strchr(lin, '\n'))
          *strchr(lin, '\n') = '\0';
        if (strchr(lin, '\r'))
          *strchr(lin, '\r') = '\0';
        return(ITRUE);
}
         