/* MWJ (C)1999 iReady */
#ifndef	FLAP_H
#define FLAP_H

#include 	<iTypes.h>
#include 	<iStacApi.h>
#include 	<iSockApi.h>
#include	"iaimtype.h"
#include	"iaimerr.h"

#define		TOC_INIT		0
#define		TOC_CONNECTED	1

/* macros */
#define		htons(x)	(U16)((x>>8) | (x<<8)) 
#define		htonl(x)	(U32)((x>>24) | ((x>>8) & 0xff00) | ((x << 8) & 0x00ff0000) | (x<<24))
#define 	ntohs(x)	htons(x)         
#define		ntohl(x)	htonl(x)

/* structures */
typedef struct	TOC_CONNECT_
{                   
	U16		state;
	U8		username[17];
	U8		password[17];          
	U8		*hostname;    
	U8		*nickname;
	IPADDR	address;
	U16		port;
	TCP_ID	socket;   
	U32		version;  
	U16		outSeq;
	U16		inSeq;
}TOC_CONNECT;


typedef struct  FLAP_HEADER_
{
    U8      id;             /* always a literal '*'     */
    U8      channel;        /* communications channel   */
    U16     sequence;       /* sequence #               */
    U16     length;         /* Length of data to follow */
    U8      data[];
}FLAP_HEADER;

typedef struct	FLAP_ELEMENT_
{
	U16				code;
	U16				len;
	U8				*data;
}FLAP_ELEMENT;

typedef struct	FLAP_INFO_
{                               
	U32				version;
	U8				channel;
	U16				sequence;
	U16				length;
	U8				*buffer;
	U8				items;		
	FLAP_ELEMENT	elements[50];
}FLAP_INFO;

typedef struct	SIGNON_
{       
	U32		version;
	U16		tlv;
	U16		userlen;
	U8		username[];
}SIGNON;


//
// Funtion Prototypes
//
IAIMRESULT	TOC_Init(U8 *, U16, TOC_CONNECT *); 
void		TOC_Disconnect(TOC_CONNECT *);
//
IAIMRESULT	TOC_Signon(TOC_CONNECT *);
IAIMRESULT	TOC_Connect(TOC_CONNECT *);
IAIMRESULT	TOC_init_done(TOC_CONNECT *);

IAIMRESULT	TOC_send_im(TOC_CONNECT *, U8 *, U8*);  
void		TOC_Process(TOC_CONNECT *);

//
IAIMRESULT	Flap_On(TOC_CONNECT	*connection);

IAIMRESULT	Flap_Send(TOC_CONNECT *, U8, U8 *, U16);
IAIMRESULT	SFlap_Send(TOC_CONNECT *,U8, U8 *);
S16			Flap_Read(TOC_CONNECT *, FLAP_INFO *, U8 *);
S16			Flap_Extract(FLAP_INFO	*);


BOOLEAN		FLAP_Get_Element(FLAP_INFO	*, U16, FLAP_ELEMENT **);

IAIMRESULT	iReadData(TCP_ID socket, U8 *pData, U16 len, TIMEOUT timeout);                                 

U8 			*condense(U8 *s);                                 
U8			*roast_password(U8 *);
U16			escape_message(U8 *);
S16			strip_html(U8 *);

#endif  


