/* MWJ (C)1999 iReady */
//#define		DEBUG	1

#include <dos.h>
#include <stdlib.h>	/* NULL */                                               
#include <stdio.h>
#include <string.h>
#include <iTypes.h>
#include <iSys.h>  

#include "aim.h"
#include "flap.h"     
#include "shell.h"
#include "dnsdrv.h"  

#define	FLAPON			"FLAPON\r\n\r\n"
#define FLAP_PORT		5190
#define ROAST 			"Tic/Toc"
#define	BUF_LEN			1024    
#define FLAP_VERSION	1
#define	TLV_TAG			1                               

#define TOC_HOST		"toc.oscar.aol.com"
#define TOC_PORT		9898
#define AUTH_HOST		"login.oscar.aol.com"
#define AUTH_PORT		5190
#define LANGUAGE		"english"
#define CLIENT_VERSION	"iReady TIC Client Version .01a"
//
// Channels
//
#define	FLAP_SIGNON			1
#define FLAP_DATA			2
#define FLAP_ERROR			3
#define	FLAP_SIGNOFF		4
#define FLAP_KEEP_ALIVE		5
//
// iReadData - Could be a generic library function.
//
IAIMRESULT
iReadData(TCP_ID socket, U8 *pData, U16 len, TIMEOUT timeout)
{
U16 		BytesRead = 0;             
U16			uselen;
RET_CODE	ret;


	uselen=len;	
	while (BytesRead < uselen)
	{             
		
		ret = isTCPRead(socket, pData, &uselen, timeout);
		if(ret != RET_CODE_OK)
			break;

		BytesRead += uselen;
		pData += BytesRead;
		uselen -= BytesRead;
	}

	return (S16)BytesRead;
}


//
//
//
IAIMRESULT
TOC_Init(server, port, connection)
U8			*server;
U16			port;
TOC_CONNECT	*connection;  
{       
IAIMRESULT	ret=IAIM_FAILURE;   

	RET_CODE			rc;

    connection->outSeq=0;
    connection->inSeq=0;
    connection->socket=0;
	connection->version=FLAP_VERSION;  
	connection->state=TOC_INIT;

	if(server==NULL)
    	connection->hostname=TOC_HOST;
    else
    	connection->hostname=server;
    
	if(port)
		connection->port=port;
	else
		connection->port=FLAP_PORT;	               
		
	if(RET_CODE_OK==(rc=dnsHostToIP(&connection->address,connection->hostname)))
	{
    	ret=IAIM_OK;      
    }
    else
	{
		ret=IAIM_FAILURE;       
    }

        	   
	return(ret);    
}


void
TOC_Disconnect(TOC_CONNECT *connection)
{
	if(connection->state!=TOC_CONNECTED)
		return;

	isTCPClose(connection->socket);   
	connection->state=TOC_INIT;
}

void
TOC_Process(connection)
TOC_CONNECT	*connection;   
{
FLAP_INFO	flap_info;
U8			buffer[1024];
FLAP_HEADER	*fh;   
U8			*pChar;         
U16			len;

	if(connection->state!=TOC_CONNECTED)
		return;
	//
	// Get Packet
	//
   	if(Flap_Read(connection,&flap_info,buffer)<0)
   	{
#if DEBUG
		printf("Flap_Read: failed\n");
#endif    				
   	}
   	else
   	{  
		fh=(FLAP_HEADER *)buffer;      
		//
		// Null terminate the string
		//
   		len=sizeof(FLAP_HEADER)+ntohs(fh->length);

   		if(len>BUF_LEN)
   			len=BUF_LEN;
   		buffer[len]=0;
    		
   		pChar=strtok(fh->data,":");  

   		if(0==strcmp(pChar,"IM_IN"))
   		{
   			pChar=strtok(NULL,":");
			printf("\n<%s>",pChar);
   			pChar=strtok(NULL,":");				
			if(pChar[0]=='T')
				printf("<Auto>");
   			pChar=strtok(NULL,":");	
   			strip_html(pChar);
   			printf("%s\n",pChar);
   			SH_Refresh();				
   		}
		else if(0==strcmp(pChar,"ERROR"))
		{
   			pChar=strtok(NULL,":");
   			if(0==strcmp(pChar,"901"))
   			{           
   				pChar=strtok(NULL,":");
   				printf("\nUser %s not available\n",pChar);
   			}
   			else
   				printf("\nError [%s] received.\n",pChar);
			SH_Refresh();    								
				
		}
/*    		else if(0==strcmp(pChar,"NICK"))
    		{
    			printf("nick\n");
    		}
    		else if(0==strcmp(pChar,"EVILED"))
    		{                                 
    			printf("eviled\n");
    		} 
*/
   		else 
   		{
   			printf("Received [%s] packet.\n",pChar);
			SH_Refresh();
		}
    }
}

                        
/*
*
*/
IAIMRESULT
TOC_Connect(connection)
TOC_CONNECT	*connection;      
{   
IAIMRESULT	ret=IAIM_FAILURE;
RET_CODE	rc;	
	//
	//
	// 																					
    rc=isTCPConnect(&connection->socket,connection->address,connection->port,1000);
    if(RET_CODE_OK!=rc)
    	return(ret);
	else
	{
#if DEBUG
    	printf("Opened socket\n");
#endif
		//
		//
		if(IAIM_FAILED( (Flap_On(connection)) ))  
		{
#if DEBUG
			printf("failed to creat a FLAP connection on server.\n");
#endif                   
			isTCPClose(connection->socket);   
			connection->state=TOC_INIT;
			ret=IAIM_FAILURE;
		}  
		else
		{
#if DEBUG
		printf("FLAP ON\n");
#endif
			//
			//
			//	
			if(IAIM_FAILED( TOC_Signon(connection) ))
			{
#if DEBUG
				printf("failed to signon\n");
#endif
				isTCPClose(connection->socket); 
				connection->state=TOC_INIT;
			}	        
			else
			{
#if DEBUG
				printf("user signed on\n");
#endif
				if(IAIM_FAILED(TOC_init_done(connection)))
				{
					isTCPClose(connection->socket);   
					connection->state=TOC_INIT;
				}
				else
    				ret=IAIM_OK;
            }
        }
	}
	return(ret);
}
                        
                        
IAIMRESULT
Flap_On(connection)
TOC_CONNECT	*connection;
{               
FLAP_INFO	flap_info;
U8			buffer[1024];
IAIMRESULT	ret=IAIM_FAILURE;    
DATA_LEN	tlen;
    //
    // Try to attach to server, send flap on.
	//    
	tlen=strlen(FLAPON);
	isTCPWrite(connection->socket, FLAPON, tlen, 200);
	//
	// Do a flap read to get the reply from the server.
	//
	if(Flap_Read(connection,&flap_info,buffer)<0)
	{
#if DEBUG	
	printf("Could not open a FLAP connection on server.\n");  		
#endif
	}
	else
	{
		if(flap_info.version==FLAP_VERSION)
		{
#if DEBUG			
			printf("Server Version Correct, inSeq=%x\n",connection->inSeq);    
#endif
			//connection->inSeq=flap_info.sequence;
			ret=IAIM_OK;
		}                          
		else
		{
#if DEBUG
			printf("Incorrect FLAP version from server [%d].\n",flap_info.version);
#endif		
		}
	}
	connection->state=TOC_CONNECTED;
	return(ret);
}


//
//
//
IAIMRESULT
TOC_Signon(connection)
TOC_CONNECT	*connection;       
{
IAIMRESULT	ret=IAIM_FAILURE;
SIGNON		*so;
U8			buffer[BUF_LEN];
U8			*pChar;
U16			len;
FLAP_INFO	flap_info;
FLAP_HEADER	*fh;                

	so=(SIGNON *)buffer;                
                
	len=strlen(connection->username);

	if(len<16)
	{
		//
		// Build Flap Signon Frame and send
		//	
		so->version	=htonl(connection->version);
		so->tlv		=htons(TLV_TAG); 
		so->userlen	=htons(len);  
		memcpy(so->username,connection->username,len);								              
		if (IAIM_FAILED(Flap_Send(connection,FLAP_SIGNON,buffer,
						(U16)(len+sizeof(SIGNON)))))
		{               
#if DEBUG
		printf("Flap_Send: failed, buffer too large?\n");
#endif			
		}				
		else
		{         
			/* wait for packet to send */
			smallSleep(30);
			//
			// Build TOC Flap Signon Frame and send (String Flap Packet Type)
			//                                     
			_snprintf(buffer, sizeof(buffer),"toc_signon %s %d %s %s %s \"%s\"",
				AUTH_HOST,
				AUTH_PORT, 
				condense(connection->username), 
				roast_password(connection->password), 
				LANGUAGE, 
				CLIENT_VERSION);

			if (IAIM_FAILED(SFlap_Send(connection,FLAP_DATA,buffer)))
			{
#if DEBUG
				printf("SFlap_Send: failed, buffer too large?\n");
#endif
			}
			else
			{ 
				//
				// Wait for response
				//
    			if(Flap_Read(connection,&flap_info,buffer)<0)
    			{
#if DEBUG
					printf("Flap_Read: failed\n");
#endif    				
    			}
    			else
    			{  
#if DEBUG
   					printf("Got login packet\n");
#endif
   				    //
    				// This should be a signon packet, but could be
    				//	an error packet.
    				//                            
    				fh=(FLAP_HEADER *)buffer;      
    				//
    				// Null terminate the string
    				//
    				len=sizeof(FLAP_HEADER)+ntohs(fh->length)+1;
    				if(len>BUF_LEN)
    					len=BUF_LEN;
    				buffer[len]=0;
    				
    				pChar=strtok(fh->data,":");  
    				
    				if(0==strcmp(pChar,"SIGN_ON"))
    				{
    					pChar=strtok(NULL,":"); 
#ifdef DEBUG
    					printf("Signed on to server version %s\n",pChar);   					
#endif
    					ret=IAIM_OK;
    				}
    				else if(0==strcmp(pChar,"ERROR"))
    				{                                
    					pChar=strtok(NULL,":"); 
    					printf("Error %s\n",pChar);   					
    				}
    			}	
			}		
		}	
	}
	return(ret);
}

IAIMRESULT
TOC_init_done(connection)
TOC_CONNECT	*connection; 
{            
IAIMRESULT	ret=IAIM_FAILURE;
U8			buffer[BUF_LEN];

	//
	// Build TOC Flap Signon Frame and send (String Flap Packet Type)
	//                                     
	_snprintf(buffer, sizeof(buffer),"toc_signon %s %d %s %s %s \"%s\"",
		AUTH_HOST,
		AUTH_PORT, 
		condense(connection->username), 
		roast_password(connection->password), 
		LANGUAGE, 
		CLIENT_VERSION);

	if (IAIM_FAILED(SFlap_Send(connection,FLAP_DATA,"toc_init_done")))
	{
#if DEBUG
		printf("SFlap_Send: failed, buffer too large?\n");
#endif
	}
	else
		ret=IAIM_OK;

	return(ret);

}

IAIMRESULT
TOC_send_im(connection,user,message)
TOC_CONNECT	*connection; 
U8			*user;
U8			*message;
{
IAIMRESULT	ret=IAIM_FAILURE;
U8			buffer[BUF_LEN];


	//escape_message(message);
    //escape_text(message);
    strcpy(buffer,"toc_send_im ");
    strcat(buffer,message);
	
	_snprintf(buffer, sizeof(buffer),"toc_send_im %s \"%s\"",
		user,message);
	
	escape_message(buffer);	
	
	if (IAIM_FAILED(SFlap_Send(connection,FLAP_DATA,buffer)))
	{
#if DEBUG
		printf("SFlap_Send: failed, buffer too large?\n");
#endif
	}
	else
		ret=IAIM_OK;

	return(ret);
}




IAIMRESULT
Flap_Send(connection,channel,buffer,len)
TOC_CONNECT	*connection;  
U8			channel;
U8			*buffer;
U16			len;                     
{
IAIMRESULT	ret=IAIM_FAILURE;
U8			outbuffer[BUF_LEN];
FLAP_HEADER *fh;
                          
	if(len<(BUF_LEN-sizeof(FLAP_HEADER)))                          
    {                      
	    fh=(FLAP_HEADER *)outbuffer;

		fh->id='*';
		fh->channel=channel;
		fh->sequence=htons(connection->outSeq+=1);
		fh->length=htons(len);
		memcpy(fh->data,buffer,len);

		isTCPWrite(connection->socket,outbuffer,(DATA_LEN)(len+sizeof(FLAP_HEADER)),200);

		ret=IAIM_OK;
	}
	else
	{
#if DEBUG
		printf("Flap_Send: Buffer passed is to large [%d > %d]\n",
			len,BUF_LEN-sizeof(FLAP_HEADER));
#endif
	}	
	return(ret);	
}


IAIMRESULT
SFlap_Send(connection,channel,buffer)
TOC_CONNECT	*connection;  
U8			channel;
U8			*buffer;
{
IAIMRESULT	ret=IAIM_FAILURE;
U8			outbuffer[BUF_LEN];
FLAP_HEADER *fh;                
U16			len;
                
	len = escape_message(buffer);
	buffer[len++]=0;                          
	if(len<(BUF_LEN-sizeof(FLAP_HEADER)))                          
    {                      
	    fh=(FLAP_HEADER *)outbuffer;

		fh->id='*';
		fh->channel=channel;
		fh->sequence=htons(connection->outSeq+=1);
		fh->length=htons(len);
		memcpy(fh->data,buffer,len);

		isTCPWrite(connection->socket,outbuffer,(DATA_LEN)(len+sizeof(FLAP_HEADER)),200);
		
		ret=IAIM_OK;
	}
	else
	{
#if DEBUG
		printf("Flap_Send: Buffer passed is to large [%d > %d]\n",
			len,BUF_LEN-sizeof(FLAP_HEADER));
#endif
	}	
	return(ret);
}


S16
Flap_Read(connection,flap_info,buffer)
TOC_CONNECT	*connection;  
FLAP_INFO	*flap_info;
U8			*buffer;
{                 
S16			ret_code=-1;
FLAP_HEADER	*flap;	
S16			flaplen,tlen;

    //
    // Read the flap header
    //                 
    //if(sizeof(FLAP_HEADER)!= (flaplen=gsReadData(connection->socket,
    //				buffer,sizeof(FLAP_HEADER),ITRUE) ))
	
	if(0==iReadData(connection->socket, buffer, sizeof(FLAP_HEADER), 800))
    {
#if	DEBUG        
        printf("Timed Out, flaplen=%d\n",flaplen);
#endif
    }
	else
    {                                        
		flap=(FLAP_HEADER *)buffer;         
		//                  
		flap_info->length=ntohs(flap->length);
		flap_info->sequence=ntohs(flap->sequence);		
		flap_info->channel=flap->channel;
		flap_info->buffer=buffer;
		//
#if DEBUG
		printf("read %d flap header bytes, %d data bytes left\n",flaplen,ntohs(flap->length));
		printf("channel %x sequence %x\n",flap->channel,flap_info->sequence);
#endif		
		//
		// Read the data
		//                  
		if(0==iReadData(connection->socket, &flap->data[0], flap_info->length, 200)) 
		{
#if DEBUG
 			printf("Timed Out, flaplen=%d\n",flaplen);
#endif
 		}          
 		else
 		{     
 			//
 			// parse the buffer.
 			//            
			flap_info->version=ntohl(*((U32 *)(&flap->data[0])));
			ret_code=Flap_Extract(flap_info);
			if(connection->state==TOC_INIT)
				connection->inSeq=flap_info->sequence;
			else if(++connection->inSeq!=flap_info->sequence)
			{
				ret_code=-2;
#if DEBUG
				printf("bad incomming sequence, old %x, new %x\n",
							connection->inSeq,flap_info->sequence);
#endif				
			}	
    	}
    }              
    return(ret_code);
}



S16
Flap_Extract(flap_info)
FLAP_INFO	*flap_info;
{
U16		index;
	//
	// Extract message
	//      
	flap_info->items=0;
	index=4; 				// Skip Version        
	while(index<flap_info->length)
	{                                        
	    flap_info->elements[flap_info->items].code=ntohs((U16)*(&flap_info->buffer[index]));
	    index+=2;
	    flap_info->elements[flap_info->items].len=ntohs((U16)*(&flap_info->buffer[index]));
		index+=2;
		flap_info->elements[flap_info->items].data=&flap_info->buffer[index];
		index+=flap_info->elements[flap_info->items].len;
	    flap_info->items++;
	}
	return(flap_info->items);
}    


/*
BOOLEAN
FLAP_Get_Element(flap_info,code,element)
FLAP_INFO		*flap_info;
U16				code;        
FLAP_ELEMENT	**element;
{                
int		i;       
BOOLEAN	rc=IFALSE;

	for(i=0;i<flap_info->items;i++)
	{
		if(element==flap_info->elements[i].code)
		{         
			*element=&flap_info->elements[i];
			rc=ITRUE;	
			break;
		}
	}                
	return(rc);
}
*/

U8 *condense(U8 *s)
{
	static char buf[BUF_LEN];
	int x=0;
	while(*s) 
	{
		if (*s != ' ') 
		{
			buf[x] = *s;
			x++;
		}
		s++;
	}
	buf[x]='\0';
	return buf;
}


U8 
*roast_password(pass)
U8	*pass;
{
	/* Trivial "encryption" */
	static char rp[30];
	static char *roast = ROAST;
	int pos=2;
	int x;
	strcpy(rp, "0x");
	for (x=0;(x<25) && pass[x]; x++) 
		pos+=sprintf(&rp[pos],"%02x", pass[x] ^ roast[x % strlen(roast)]);
	rp[pos]='\0';
	return rp;
}

U16	
escape_message(msg)
U8		*msg;
{
	char *c, *cpy;
	int cnt=0;
	/* Assumes you have a buffer able to cary at least BUF_LEN * 2 bytes */
	if (strlen(msg) > BUF_LEN) 
	{
		fprintf(stderr, "Warning:  truncating message to 1024 bytes\n");
		msg[1023]='\0';
	}
	
	cpy = strdup(msg);
	c = cpy;
	while(*c) 
	{
		switch(*c) 
		{
		case '$':
		case '[':
		case ']':
		case '(':
		case ')':
		case '#':
			msg[cnt++]='\\';
			/* Fall through */
		default:
			msg[cnt++]=*c;
		}
		c++;
	}
	msg[cnt]='\0';
	free(cpy);
	return cnt;
}


int escape_text(char *msg)
{
	char *c, *cpy;
	int cnt=0;
	/* Assumes you have a buffer able to cary at least BUF_LEN * 2 bytes */
	if (strlen(msg) > BUF_LEN) 
	{
		fprintf(stderr, "Warning:  truncating message to 1024 bytes\n");
		msg[1023]='\0';
	}
	
	cpy = strdup(msg);
	c = cpy;
	while(*c) 
	{
		switch(*c) 
		{
		case '{':
		case '}':
		case '\\':
		case '"':
			msg[cnt++]='\\';
			/* Fall through */
		default:
			msg[cnt++]=*c;
		}
		c++;
	}
	msg[cnt]='\0';
	free(cpy);
	return cnt;
}

S16
strip_html(buffer)
U8		*buffer;
{  
U8		*c1,*c2;
U16		count=0;
U16		cnt=0,t;
	
	if((t=strlen(buffer))>BUF_LEN)
	{
		buffer[BUF_LEN-1]=0;
	}

	c2=buffer;
	c1=strdup(buffer);	
	while(*c1)	
	{
		if(*c1=='<')
			count++;
		else if(*c1=='>')
		{
			if(count>0)
				count--;
			else
			{
				buffer[cnt++]='>';
			}
		}		
		else if(count==0) 
			buffer[cnt++]=*c1;
		*c1++;					
	}
	buffer[cnt]=0;
	free(c1);        

	return(cnt);
}



/*
U8
**ispit(U8 *, U8 delim)
U8		*str;
U8		delim;
{               
static	U8	buffer[;
static	U8	*splits[25];
U16			num;
*/
             
             
             
             


