/* MWJ (C)1999 iReady */
#include <windows.h>
#include <string.h>
#include "aim.h"
#include "gensock.h"

static BOOLEAN Initialized = IFALSE;
static BOOLEAN (IFAR *Callback)() = NULL;

BOOLEAN
processAborted(void)
{
	return (Callback && Callback());
}

IAIMRESULT
gsIsLinkUp(BOOLEAN (IFAR *callback)())
{
	Callback = callback;
	return (IAIMRESULT)1;
}

IAIMRESULT
gsEstablishLink(char *phone, char *username, char *password)
{
	return IAIM_OK;
}

IAIMRESULT
gsInit(U32 parm, BOOLEAN (IFAR *callback)())
{
	WSADATA wsadata;
	
	if (!Initialized)
	{
		//printf("chk1\n");	                  
		imin_init();
		//printf("chk2\n");
		initPPP();
		//printf("chk3\n");
		smallSleep( 800 );
		startPPP();
		//printf("chk5\n");                  

		imin_cbAdd(5, pppTask, NULL);  
		Initialized = ITRUE;
	}

	Callback = callback;
	return Initialized ? IAIM_OK : IAIM_FAILURE;
}

IAIMRESULT
gsOpenSocket(U16 socketNum, IPADDR ipaddr, U16 port)
{
	IAIMRESULT Ret = IAIM_FAILURE;
	SOCKADDR_IN addr;
	SOCKET sock;
	u_long ulCmdArg = 1;
	int ret;
	struct timeval tv;
	fd_set writefds;
	fd_set exceptfds;
	
	sock = socket(AF_INET, SOCK_STREAM, 0);
	if (sock != SOCKET_ERROR)
	{
		addr.sin_family = AF_INET;
		addr.sin_port = htons(0);
		addr.sin_addr.s_addr = htonl(INADDR_ANY);

		if (bind(sock, (LPSOCKADDR)&addr, sizeof(addr)) != SOCKET_ERROR)
		{
			addr.sin_port = htons(port);
			addr.sin_addr.s_addr = ipaddr.ip32;

			ioctlsocket(sock, FIONBIO, &ulCmdArg);

			ret = connect(sock, (LPSOCKADDR)&addr, sizeof(addr));

			if (ret == SOCKET_ERROR)
			{
				if (WSAGetLastError() == WSAEWOULDBLOCK)
				{
					tv.tv_sec = 0;
					tv.tv_usec = 2500;

					while (1)
					{
						FD_ZERO(&writefds);
						FD_SET(sock, &writefds);

						FD_ZERO(&exceptfds);
						FD_SET(sock, &exceptfds);

						select(0, NULL, &writefds, &exceptfds, &tv);

						if (FD_ISSET(sock, &writefds))
						{
							Ret = (IAIMRESULT)sock;
							break;
						}
						else if (FD_ISSET(sock, &exceptfds))
							break;
						else if (processAborted())
						{
							Ret = IAIM_USERABORT;
							break;
						}
					}
				}
			}
			else
				Ret = (IAIMRESULT)sock;
		}
	}

	return Ret;
}

IAIMRESULT
gsWriteData(S16 socket, pU8 pData, U16 len)
{
	U16 BytesSent = 0;
	int ret;
	ISTR ptr = (ISTR)pData;

	if (socket <= 0)
		return IAIM_FAILURE;

	while (BytesSent < len)
	{
		if (processAborted())
			return IAIM_USERABORT;

		ret = send(socket, (const char FAR *)&pData[BytesSent],
			len - BytesSent, 0);

		if (ret != SOCKET_ERROR)
			BytesSent += ret;
		else if (WSAGetLastError() != WSAEWOULDBLOCK)
			break;
	}

	return BytesSent;
}

IAIMRESULT
gsIsDataAvailable(S16 socket)
{
	char peek;
	int ret = recv(socket, &peek, 1, MSG_PEEK);

	isTCPRead(socket, NULL, len, TMO_NO_RETRY);		

//printf("ret=%x\n");	
	if (ret == SOCKET_ERROR)
		ret = 0;

	return (IAIMRESULT)ret;
}

IAIMRESULT
gsReadData(S16 socket, pU8 pData, U16 len, BOOLEAN WaitOnAll)
{
	int BytesRead = 0;
	int ret;

	if (!WaitOnAll && !gsIsDataAvailable(socket))
		return 0;
	
	while (BytesRead < len)
	{
		ret = recv(socket, (char FAR *)pData, len, 0);
		if (!ret)
			break;

		if (ret != SOCKET_ERROR)
		{
			BytesRead += ret;
			pData += BytesRead;
			len -= BytesRead;
		}

		if (!WaitOnAll && !gsIsDataAvailable(socket))
			break;

		if ((BytesRead < len) && processAborted())
			return IAIM_USERABORT;
	}

	return (S16)BytesRead;
}

IAIMRESULT
gsCloseSocket(S16 socket)
{
	closesocket(socket);
	return IAIM_OK;
}

IAIMRESULT
gsHostnameToIP(char *hostname, IPADDR *pAddr)
{
	IN_ADDR addr;
	
	PHOSTENT phostent = gethostbyname(hostname);
	
	if (phostent)
	{
		memcpy(&addr, phostent->h_addr, 4);
		pAddr->ip32 = addr.s_addr;
		return IAIM_OK;
	}

	return IAIM_FAILURE;
}
