/* 
 * Copyright (c) 1997 iREADY Corporation.  Patents pending.  Unpublished - 
 * rights reserved under the Copyright Laws of the United States.  Use, 
 * duplication, or disclosure by the U.S. Government is subject to the 
 * restrictions as set forth in DFARS 252.227-7013(c)(1) and FAR 
 * 52.227-14(a).  
 *      
 * This product, including the documentation, is licensed solely for 
 * your internal use.  No third party may use the product nor may you use 
 * the product on behalf of any third party.
 *      
 * EXCEPT AS MAY BE SPECIFIED IN ANY APPLICABLE LICENSE AGREEMENT, 
 * iREADY CORPORATION PROVIDES THE PRODUCT "AS IS" AND DOES NOT WARRANT 
 * THAT THE FUNCTIONS CONTAINED IN THE PRODUCT WILL MEET ANY SPECIFIC 
 * REQUIREMENTS, THAT THE PRODUCT IS FIT FOR ANY PARTICULAR PURPOSE OR 
 * THAT THE OPERATION OF THE PRODUCT WILL BE UNINTERRUPTED, ERROR FREE 
 * OR VIRUS FREE.
 *
 * Revision 1.0  M. Johnson
 *   Original Program.
 */
#ifndef DNSDRV_H
#define DNSDRV_H
#ifdef DODEPENDS
#pragma _DEPENDS
#endif

#ifdef __cplusplus
extern "C"
{
#endif

#include <itypes.h>


#define	DNS_BAD_RESPONSE_ID						-1100
#define DNS_BAD_RESPONSE_TYPE					-1101
#define DNS_BAD_RESPONSE_NOANSWERS				-1102   
#define DNS_BAD_RESPONSE_QUESTION_DOMAIN_NAME   -1103
#define DNS_BAD_ANSWER_DOMAIN_NAME			   	-1104
#define DNS_BAD_RESPONSE_NO_ADDRESS_RECORD		-1105     
#define DNS_BAD_RESPONSE_ADDRESS_LENGTH			-1106
#define DNS_NO_REPLY							-1107




typedef BOOLEAN (*DNSBLOCKINGCALLBACKPROC)(void);

//void dnsSetBlockingCallback(DNSBLOCKINGCALLBACKPROC);
RET_CODE dnsHostToIP(IPADDR *ipaddr, U8 *hostname);
BOOLEAN dnsIPToHost(IPADDR dnsip, IPADDR ipaddr, U8 *hostname, U16 maxlen);

#ifdef __cplusplus
}
#endif

#endif
