/*
 *
 * Copyright (c) 1997 iREADY Corporation.  Patents pending.  Unpublished - 
 * rights reserved under the Copyright Laws of the United States.  Use, 
 * duplication, or disclosure by the U.S. Government is subject to the 
 * restrictions as set forth in DFARS 252.227-7013(c)(1) and FAR 
 * 52.227-14(a).  
 *      
 * This product, including the documentation, is licensed solely for 
 * your internal use.  No third party may use the product nor may you use 
 * the product on behalf of any third party.
 *      
 * EXCEPT AS MAY BE SPECIFIED IN ANY APPLICABLE LICENSE AGREEMENT, 
 * iREADY CORPORATION PROVIDES THE PRODUCT "AS IS" AND DOES NOT WARRANT 
 * THAT THE FUNCTIONS CONTAINED IN THE PRODUCT WILL MEET ANY SPECIFIC 
 * REQUIREMENTS, THAT THE PRODUCT IS FIT FOR ANY PARTICULAR PURPOSE OR 
 * THAT THE OPERATION OF THE PRODUCT WILL BE UNINTERRUPTED, ERROR FREE 
 * OR VIRUS FREE.
 *
 * Revision 1.0  M. Johnson
 *   Original Program.
 */
#include <string.h>
//#include <itypes.h>
#include <iTypes.h>
#include <iSys.h>  
#include <iStacApi.h>
#include <iSockApi.h>
#include "dnsdrv.h"  
#include "flap.h"
 
/* MWJ need to do somthing about istrcat */
#define	istrcat		strcat
#define istrncat	strncat 
 
 
#define BUFFER_SIZE 512                   

#define MAX_DNS_SERVER	2    

static U16		dns_server_count=0;                                         
static IPADDR	dns_server[MAX_DNS_SERVER];
static U16 dnsID = 0;
static DNSBLOCKINGCALLBACKPROC Callback = 0;

static void
dnsAddWord(U16 val, U8 *ptr)
{
#ifdef LITTLE_ENDIAN
	*ptr++ = (U8)((val >> 8) & 0xff);
	*ptr++ = (U8)(val & 0xff);
#else
	*ptr++ = (U8)(val & 0xff);          
	*ptr++ = (U8)((val >> 8) & 0xff);          
#endif
}


S16
dnsAddNameServer(IPADDR server)
{              
S16	rc;        

	if(dns_server_count<MAX_DNS_SERVER)
	{
		dns_server[dns_server_count++]=server;
		rc=0;
	}                                 
	else
		rc=-1;
		
	return(rc);
}

static BOOLEAN 
dnsReadDomainName(U8 *buffer, U8 *str, U16 **ppu16)
{
	BOOLEAN Done = IFALSE;
	BOOLEAN FollowedOffset = IFALSE;
	U8 *pu8 = (U8 *)*ppu16;
	U16 Temp, Offset;
	U8 len;

	if (str)
		*str = 0;
 
 
	while (!Done)
	{
		if (*pu8 & 0xc0)
		{
			Temp = *(U16 *)pu8;
			Offset = ((*pu8 << 8) | pu8[1]);
			Offset &= 0x3fff;

			pu8 = &buffer[Offset];

			if (!FollowedOffset)
				(*ppu16)++;

			FollowedOffset = ITRUE;
		}
		else
		{
			if (!*pu8)
			{
				if (str)
					str[istrlen((char *)str) - 2] = 0;

				pu8++;

				if (!FollowedOffset)
					*ppu16 = (U16 *)pu8;

				Done = ITRUE;
			}
			else
			{
				len = *pu8++;
				if (str)
				{
					istrncat((char *)str, (char *)pu8, len);
					istrcat((char *)str, ".");
				}

				pu8 += len;

				if (!FollowedOffset)                                            
				
					*ppu16 = (U16 *)pu8;
			}
		}
	}

	return ITRUE;
}


/*
	ret_code = dnsHostToIP(*ipaddr, *hostname);
	
		
*/
RET_CODE
dnsHostToIP(IPADDR *ipaddr, U8 *hostname)
{
	U8					buffer[BUFFER_SIZE];
	U16 				len, i, Temp, ID, NumQuestions, NumAnswers;
	U8 					*pu8, *ptr;
	U16 				*pu16;
	BOOLEAN 			FoundAddressRecord = IFALSE;
	SOCK_INFO			sock_info;
	UDP_ID				socket;
	RET_CODE			rc; 
	RET_CODE			dns_rc=RET_CODE_OK;                       
	U8					dns_count;
       
//	ITRACE(ITNC_DNSHOSTTOIP_ENTERED, dnsip, hostname);

	ipaddr->ip32 = 0;

	if((rc=isUDPCreate(&socket,53))!=RET_CODE_OK)
	{
//		ITRACE(ITNC_DNSHOSTTOIP_CANT_OPEN_SOCKET);	 	
		dns_rc=RET_CODE_FAIL;
	}
	else
	{
		dns_count=0;
		while((dns_server[dns_count].ip32!=0) && (dns_count < dns_server_count ))  
		{
            /* Build Request Message in buffer */
			len = 0;             
		    
		    /* set the dns id to its current value */
			dnsAddWord(dnsID,&buffer[len]);
			len += 2;
			/* store flags field (for more info see Stevens Vol. 1 pg 191)
			// We always use 01 00 for a query, this asks the name server to 
			// do all the work.
			*/
			dnsAddWord(0x0100,&buffer[len]);
			len += 2;
		  																	
			/* store number of questions, we always ask only 1 question.	*/		
			dnsAddWord(1,&buffer[len]);
			len += 2;   
									
			/* store number of answers, always 0	*/		
			dnsAddWord(0,&buffer[len]);
			len += 2;   		                            
        	
			/* store number of Autority RR's, always 0 */
			dnsAddWord(0,&buffer[len]);
			len += 2;   

			/* store number of Aditional RR's, always 0 */
			dnsAddWord(0,&buffer[len]);
			len += 2;
					
			/* Store Hostname to resolve */
			ptr = hostname;
			while (*ptr)
			{
				i = 0;
				while (ptr[i] && ptr[i] != '.')
					i++;

				buffer[len++] = (U8)i;
    	
				while (i--)
					buffer[len++] = *ptr++;

				if (*ptr)
					ptr++;
			}
			buffer[len++] = 0;


			/* Query Type, 00 01 is we want an IP address, use 00 05 if       	*/
			/*	you want to resolve an IP address to a name.		        	*/
			dnsAddWord(1, &buffer[len]);
			len += 2;
        
	        /* Query Class, Always sue 00 01 for IP. */
			dnsAddWord(1, &buffer[len]);
			len += 2;

			/* do request with server count */	
			sock_info.ip = dns_server[dns_count];
			sock_info.port = 53;
			rc=isUDPWrite(socket, &sock_info, buffer, len, 100);

			/* wait for reply */		
			len = BUFFER_SIZE;

			if(rc=isUDPRead(socket, &sock_info, buffer,	&len, 1000)==RET_CODE_OK)
			{   
				/* check for DNS id */
				pu16 = (U16 *)buffer;
				ID = ntohs (*pu16);
				pu16++;
				if (ID != dnsID)
				{
//					ITRACE(ITNC_DNSHOSTTOIP_BAD_RESPONSE_ID);
					dns_rc=DNS_BAD_RESPONSE_ID;
				}
				else
				{

					if (!(*pu16++ & 0x8000))
					{
//						ITRACE(ITNC_DNSHOSTTOIP_BAD_RESPONSE_TYPE);
						dns_rc=DNS_BAD_RESPONSE_TYPE;
					}
					else
					{               
						/* get num of questions */
						NumQuestions=ntohs(*pu16);
                        pu16++;
						/* Check NumAnswers */
						NumAnswers=ntohs(*pu16);
						pu16++;
						if (!NumAnswers)
						{
//							ITRACE(ITNC_DNSHOSTTOIP_BAD_RESPONSE_NOANSWERS);
							dns_rc=DNS_BAD_RESPONSE_NOANSWERS;
						}
						else
						{   
							//
							// Skip NumAuthorities and NumAdditional
							//
							pu16++;
							pu16++;
                            //
                            // Read out questions and dump them.
                            //
							while (dns_rc==RET_CODE_OK && NumQuestions--)
							{
								if (!dnsReadDomainName(buffer, NULL, &pu16))
								{
//									ITRACE(ITNC_DNSHOSTTOIP_BAD_RESPONSE_QUESTION_DOMAIN_NAME);
									dns_rc=DNS_BAD_RESPONSE_QUESTION_DOMAIN_NAME;
								}
								else
								{    
									//									
									// Skip Type and Class
									//
									pu16++;
									pu16++;  
								}
							}
						}
                        //
						// Loop until we get an answer of type 0x0001 (host address)
						//
						while (dns_rc==RET_CODE_OK && !FoundAddressRecord && NumAnswers--)
						{
							if (!dnsReadDomainName(buffer, NULL, &pu16))
							{
//								ITRACE(ITNC_DNSHOSTTOIP_BAD_RESPONSE_ANSWER_DOMAIN_NAME);
								dns_rc=DNS_BAD_ANSWER_DOMAIN_NAME;
							}
							else
							{
								// Check Type 
								//      
								if (*pu16++ == 0x0100)
									FoundAddressRecord = ITRUE;
							
								// Skip class	
								//
								pu16++;	

								// Skip TTL
								//
								pu16++;
								pu16++;

								if (!FoundAddressRecord)
								{
									// Get length and skip that many bytes
									//
									len = ntohs(*pu16);
									pu16++;
									pu8 = (U8 *)pu16;
									pu8 += len;
									pu16 = (U16 *)pu8;
								}
							}
						}

						if (!FoundAddressRecord)
						{
//							ITRACE(ITNC_DNSHOSTTOIP_BAD_RESPONSE_NO_ADDRESS_RECORD);
							dns_rc=DNS_BAD_RESPONSE_NO_ADDRESS_RECORD;
						}
						else
						{
							// Check length
							//
							if (*pu16++ != 0x0400)
							{
//								ITRACE(ITNC_DNSHOSTTOIP_BAD_RESPONSE_ADDRESS_LENGTH);
								dns_rc=DNS_BAD_RESPONSE_ADDRESS_LENGTH;
							}
							else
							{
								pu8 = (U8 *)pu16;
								ipaddr->ipb1 = *pu8++;
    							ipaddr->ipb2 = *pu8++;
    							ipaddr->ipb3 = *pu8++;
    							ipaddr->ipb4 = *pu8++;  
    							dns_rc=RET_CODE_OK;
    							break;
							}
						}
					}
				}
			}
		    dns_count++;	
		}
	}

	if(dns_count>=dns_server_count)
		dns_rc=DNS_NO_REPLY;

	if (socket != 0)
		isUDPRelease(socket);
	//
	// Incerment dns id counter for next query.
	//
	dnsID++;
	//
	// Zero out return to 0 if no address found
	//
	if (!FoundAddressRecord)
	{
		ipaddr->ip32=0;
	}					
//	ITRACE(ITNC_DNSHOSTTOIP_EXITED, Ret);
	return(dns_rc);
}



int
dnsIPToHost(IPADDR dnsip, IPADDR ipaddr, U8 *hostname, U16 maxlen)
{
//	ITRACE(ITNC_DNSIPTOHOST_ENTERED, dnsip, ipaddr);
//	ITRACE(ITNC_DNSIPTOHOST_EXITED, IFALSE);
	return IFALSE;
}

void 
dnsSetBlockingCallback(DNSBLOCKINGCALLBACKPROC callback)
{
//	ITRACE(ITNC_DNSSETBLOCKINGCALLBACK_ENTERED, callback);
	Callback = callback;
//	ITRACE(ITNC_DNSSETBLOCKINGCALLBACK_EXITED);
}
