//
// Shell Commands for iReady IM - Mike Johnson
//                             

#include	<string.h>
#include	"aim.h"             
#include	"flap.h"
#include	"shell.h" 
#include	"commands.h"  

// Login [username] [password]
//
// Logoff
//
// M user message
//
// buddy add name
// 		 del name
//
// allow buddy
//		 all
//		 none
//       user [username]
//
//	evil user norm|anon
//		 
//	info [username]
//


BOOLEAN
I_CMD_Logout(action)
U16		action;
{
static SH_CMD	Logout;
static U8		logout_state=0;

	
	if(action==0)
	{
		if(logout_state==1)
		{
			//
			// Remove Logout command
			//  
			SH_DeRegister(&Logout);          
			logout_state=0;
			return ITRUE;
		}    
		else
			return IFALSE;
	}
	else
	{  
		if(logout_state==0)
		{      
			//
			// Add Logout Command
			//    
			Logout.cmd="logout";
			Logout.handler=&CMD_Logout;
			SH_Register(&Logout);			               
			logout_state=1;
		}
		else
			return IFALSE;
	}
}

void
CMD_Logout(command_list,num_commands)
U8		*command_list[];
U8		num_commands;
{        
	//
	// Log the user out by closeing the socket and removing the
	//		active commands
	//
	TOC_Disconnect(connection);
	//
	// add login command
	//
	I_CMD_Login(CMD_ON);
	//
	// Remove active commands
	//
	I_CMD_Logout(CMD_OFF);	  
	I_CMD_Message(CMD_OFF);
	//
	// Set shell prompt to default
	//                            
	SH_Prompt(NULL);
} 


BOOLEAN
I_CMD_Login(action)
U16		action;
{
static SH_CMD	Login;
static U8		login_state=0;

	
	if(action==0)
	{
		if(login_state==1)
		{
			//
			// Remove Logout command
			//            
			SH_DeRegister(&Login);   
			login_state=0;
			return ITRUE;
		}    
		else
			return IFALSE;
	}
	else
	{  
		if(login_state==0)
		{      
			//
			// Add Logout Command
			//    
			Login.cmd="login";
			Login.handler=&CMD_Login;
			SH_Register(&Login);			               
			login_state=1;   
		}
		else
			return IFALSE;
	}
}

void
CMD_Login(command_list,num_commands)
U8			*command_list[];
U8			num_commands;
{        
	//
	// Command format is "login username password"
	//                                  
	if(num_commands!=3)
	{
		printf("login [username] [password]\n");
		return;
	}   
    //
    // Try to login the user.
    //                       
    //
    // Do a TOC_Init to reset the connection structure and to set
    //	the server.
    //
	if(IAIM_FAILED(TOC_Init(NULL,0,connection)))
	{
		printf("DNS failed Lookup of TOC Server %s.\n",connection->hostname);
		return;
	};         
	//
	// Add the username and password to the connection struct.
	//
	strncpy(connection->username,command_list[1],16);
	connection->username[16]=0;		
	strncpy(connection->password,command_list[2],16);
	connection->password[16]=0;
	//
	// Print out a message
	//
    printf("User %s connecting to %s, Using IP %d.%d.%d.%d\n",connection->username,
    	connection->hostname,connection->address.ipb1, connection->address.ipb2, 
    	connection->address.ipb3, connection->address.ipb4);
    //
    // Connect to TOC server.
    //
    if(IAIM_OK!=TOC_Connect(connection))
    {
    	printf("Failed to connect\n");
        return;
    }	       
    //
    // We are connected.  Remove login command, and add active commands
    //                                                                 
	I_CMD_Login(CMD_OFF);
	I_CMD_Logout(CMD_ON);
	I_CMD_Message(CMD_ON);
	SH_Prompt("[c]#");
			    
} 



BOOLEAN
I_CMD_Message(action)
U16		action;
{
static SH_CMD	Message;
static U8		message_state=0;

	
	if(action==0)
	{
		if(message_state==1)
		{
			//
			// Remove Logout command
			//  
			SH_DeRegister(&Message);          
			message_state=0;
			return ITRUE;
		}    
		else
			return IFALSE;
	}
	else
	{  
		if(message_state==0)
		{      
			//
			// Add Logout Command
			//    
			Message.cmd="m";
			Message.handler=&CMD_Message;
			SH_Register(&Message);			               
			message_state=1;
		}
		else
			return IFALSE;
	}
}

void
CMD_Message(command_list,num_commands)
U8		*command_list[];
U8		num_commands;
{              
U16		i;
U8		buffer[1024];
	//
	// Command format is "m username message..."
	//                                  
	if(num_commands<3)
	{
		printf("m [username] [message...]\n");
		return;
	}                         
	//
	// build the buffer.
	//                                   
	strcpy(buffer,command_list[2]);
	for(i=3;i<num_commands;i++)
	{
		strcat(buffer," ");
		strcat(buffer,command_list[i]);
	}
	TOC_send_im(connection,command_list[1],buffer);
}
