<?
//
// 9100a.php - Simple Image Grabber for the aviosys 9100a video server
// Copyright (C) 2005 - Mike Johnson - www.mycal.net
//
// uses 'GET' with paramters server=<server> port=<tcp port to use [default 80]> vport=<video port on 9100a to grab 0-3 [default 0]>
//
// Example http://<server script is installed on>/9100a.php?PHP_server=192.168.5.5&PHP_port=80&PHP_vport=0
//
// This script can run on the same server as zoneminder, or on a seperate server.  One script can service multiple 9100a
// boxes.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//



// Default Paramters
$server     = '10.10.11.106';       // put default 9100 server IP address or name here, will be used in none passed
$port       = 80;
$vport      = 0;
$debug      = 0;        
$boundry    = '--WINBONDBOUDARY';
$buffer_len = 4096;                // Socket Buffer len
$max_errors = 32;                    // Maximum errors before giving up


//
// Initialize variables
//
// First set server
//
//if(defined($_GET['PHP_server']))
//    $server=$_GET['PHP_server'];
if(strlen($_GET['PHP_server']))
    $server=$_GET['PHP_server'];
//
// Set TCP port
//
if(strlen($_GET['PHP_port']))
    $port=$_GET['PHP_port'];
//
// Set video port to grab
//
if(strlen($_GET['PHP_vport']))
    $vport=$_GET['PHP_vport'];




//
// dump($buffer,$start,$len_to_dump)
//
function dump($buffer,$start,$len)
{
    for($i=$start;$i<$len+$start;$i++)
        echo $buffer[$i];
}


//
// binary search (quick hack) find a $needle($len) in $haystack($len) 
//
// Returns positive index to start of string if found
//
function binarysearch($needle,$needle_len,$haystack,$haystacklen)
{
    $c=0;
    while(1)
    {
        // Match the first char first
 
        if($needle[0]==$haystack[$c])
        {
            // Now match string
            $match=1;
            for($i=1;$i<$needle_len;$i++)
            {
                if($needle[$i]==$haystack[$c+$i])
                {
                    continue;
                }
                else
                {
                    $match=0;
                    $i=$needle_len;
                }
            }
            if($match)
                return $c;
        }
        $c++;


        if($c>=$haystacklen)
            break;
    }
    return -1;
}


//
// Main Code Starts Here
//

if(1==$debug)
    error_reporting(E_ALL);
else
    error_reporting(0);

if(1==$debug)
    echo 'test test test<br>';

// Get the IP address for the target host.
$address = gethostbyname($server);

// Create a TCP/IP socket. 
$socket = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);

if ($socket < 0) 
{
        echo "socket_create() failed: reason: " . socket_strerror(socket_last_error()) . "\n";
        exit(1);
} 
else 
{
    if(1==$debug)
        echo "OK.\n";
}


if(1==$debug)
    echo "Attempting to connect to '$address' on port '$port'...";

$result = socket_connect($socket, $address, $port);

if (false == $result) 
{
        echo "socket_connect() failed.\nReason: (" . socket_strerror(socket_last_error()) . ")\n";
        exit(1);
} 
else 
{
    if(1==$debug)
        echo "OK.\n";
}


$out        = "GET /GetData.cgi HTTP/1.0\r\n\r\n";

if(1==$debug)
    echo "Sending HTTP request to 9100...";


socket_write($socket, $out, strlen($out));

if(1==$debug)
{
    echo "OK.\n";
    echo "Reading response:\n\n";
}
//
// Look for the image and dump it.
//
$mode=0;
$ecount=0;
$boundry_len=strlen($boundry);
while($i=socket_read($socket,$buffer_len, PHP_BINARY_READ))
{

    // Get the number of bytes read by socket_read
    $real_len=strlen($i);

    if(($c=binarysearch($boundry,$boundry_len, $i,$real_len))>=0)
    {
        // We found the boundry
        // check mode
        if(0==$mode)
        {
            // Build offsets
            $start=$c+$boundry_len+30;                          // Index into the start of jpg
            $cport=$start+14;                                   // location of port ID

            //
            // Check to see if this is the port we are looking for, index into cport and check to passed port
            //
            if(bin2hex($i[$cport])!=$vport)
            {
                // not the port we want, inc counter and contiune to read stream, exit if error count reached.
                $ecount++;
                if($ecount > $max_errors)
                    break; 
                continue;
            }

            header("Content-type: image/jpeg");     
            // Check for desired port to return at offset x
            dump($i,$c+$boundry_len+30,$real_len-($c+$boundry_len+30));
            $mode=1;
        }
        else
        {
            // we are currently returning data, return data up until the new header and then exit
            dump($i,0,$c);
            break;
        }
    }
    else
    {

        // No header found in this chunk
        //
        // Check mode, if mode 1 send data, else just drop it (do nothing)
        if(1==$mode)
            dump($i,0,$real_len); 
        else
        {
            $ecount++;
            if($ecount > $max_errors)
            {
                if(1==$debug)
                    echo 'No boundry header found - Exiting<br>';
                break;
            }
        }
    }
}

if(1==$debug)
    echo "Closing socket...";

socket_close($socket);


?>
